/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.html.HtmlUtil;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.slim.HtmlDiffUtil;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;

public class HtmlTable
implements Table {
    private static final Logger LOG = Logger.getLogger(HtmlTable.class.getName());
    private static final String SYMBOL_ASSIGNMENT = "\\$[A-Za-z]\\w*<?->?\\[";
    private static final String SYMBOL_ASSIGNMENT_SUFFIX = "\\]";
    private static final Pattern HTML_PATTERN = Pattern.compile("^(?:\\$[A-Za-z]\\w*<?->?\\[)?<(p|hr|pre|ul|ol|dl|div|h[1-6]|hgroup|address|blockquote|ins|del|object|map|video|audio|figure|table|fieldset|canvas|a|em|strong|small|mark|abbr|dfn|i|b|s|u|code|var|samp|kbd|sup|sub|q|cite|span|br|ins|del|img|embed|object|video|audio|label|output|datalist|progress|command|canvas|time|meter)([ >].*</\\1>|[^>]*/>)\\]?$", 34);
    private static final Pattern SYMBOL_REPLACEMENT_PATTERN = Pattern.compile("^(\\$[A-Za-z]\\w*<?->?\\[)(.*)(\\])$", 34);
    private List<Row> rows = new ArrayList<Row>();
    private TableTag tableNode;

    public HtmlTable(TableTag tableNode) {
        this.tableNode = tableNode;
        NodeList nodeList = tableNode.getChildren();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = nodeList.elementAt(i);
            if (!(node instanceof TableRow) && !(node instanceof TableHeader)) continue;
            this.rows.add(new Row((CompositeTag)node));
        }
    }

    public TableTag getTableNode() {
        return this.tableNode;
    }

    @Override
    public String getCellContents(int columnIndex, int rowIndex) {
        return this.rows.get(rowIndex).getColumn(columnIndex).getContent();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCountInRow(int rowIndex) {
        return this.rows.get(rowIndex).getColumnCount();
    }

    @Override
    public void substitute(int col, int row, String contents) {
        Cell cell = this.rows.get(row).getColumn(col);
        cell.setContent(contents);
    }

    public List<List<String>> asList() {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Row row : this.rows) {
            list.add(row.asList());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.asList().toString();
    }

    public String toHtml() {
        return this.tableNode.toHtml();
    }

    @Override
    public int addRow(List<String> list) {
        Row row = new Row();
        this.rows.add(row);
        this.tableNode.getChildren().add((Node)row.getRowNode());
        for (String s : list) {
            row.appendCell(s == null ? "" : HtmlTable.asHtml(s));
        }
        return this.rows.size() - 1;
    }

    @Override
    public void addColumnToRow(int rowIndex, String contents) {
        Row row = this.rows.get(rowIndex);
        row.appendCell(HtmlTable.asHtml(contents));
    }

    @Override
    public void appendChildTable(int rowIndex, Table childTable) {
        Row row = this.rows.get(rowIndex);
        Row childRow = this.makeChildRow(row, (Node)((HtmlTable)childTable).getTableNode(), "scenario");
        this.insertRowAfter(row, childRow);
    }

    private Row makeChildRow(Row row, Node contents, String type) {
        Row childRow = new Row();
        TableColumn column = (TableColumn)HtmlTable.newTag(TableColumn.class);
        column.setChildren(new NodeList(contents));
        column.setAttribute("colspan", "" + this.colspan(row), '\"');
        childRow.appendCell(new Cell(column));
        row.rowNode.setAttribute("class", type + " closed", '\"');
        childRow.rowNode.setAttribute("class", type + "-detail closed-detail", '\"');
        return childRow;
    }

    private int colspan(Row row) {
        NodeList rowNodes = row.rowNode.getChildren();
        int colspan = 0;
        for (int i = 0; i < rowNodes.size(); ++i) {
            if (!(rowNodes.elementAt(i) instanceof TableColumn)) continue;
            String s = ((TableColumn)rowNodes.elementAt(i)).getAttribute("colspan");
            if (s != null) {
                colspan += Integer.parseInt(s);
                continue;
            }
            ++colspan;
        }
        return colspan;
    }

    private void insertRowAfter(Row existingRow, Row childRow) {
        NodeList rowNodes = this.tableNode.getChildren();
        int index = rowNodes.indexOf((Node)existingRow.rowNode);
        Stack<Node> tempStack = new Stack<Node>();
        while (rowNodes.size() - 1 > index) {
            tempStack.push(rowNodes.elementAt(this.tableNode.getChildren().size() - 1));
            rowNodes.remove(rowNodes.size() - 1);
        }
        rowNodes.add((Node)childRow.rowNode);
        while (!tempStack.isEmpty()) {
            rowNodes.add((Node)tempStack.pop());
        }
    }

    @Override
    public void updateContent(int rowIndex, TestResult testResult) {
        this.rows.get(rowIndex).setExecutionResult(testResult.getExecutionResult());
    }

    @Override
    public void updateContent(int col, int row, SlimTestResult testResult) {
        Cell cell = this.rows.get(row).getColumn(col);
        cell.setTestResult(testResult);
        String newContent = cell.formatTestResult();
        if (newContent != null) {
            cell.setContent(newContent);
        }
    }

    @Override
    public void updateContent(int colIndex, int rowIndex, SlimExceptionResult exceptionResult) {
        Row row = this.rows.get(rowIndex);
        Cell cell = row.getColumn(colIndex);
        if (exceptionResult.hasMessage()) {
            cell.setExceptionResult(exceptionResult);
        } else {
            Row childRow = this.makeChildRow(row, (Node)new TextNode("<pre>" + HtmlUtil.escapeHTML(exceptionResult.getException()) + "</pre>"), "exception");
            this.insertRowAfter(row, childRow);
            row.setExecutionResult(exceptionResult.getExecutionResult());
        }
    }

    private static Tag newTag(Class<? extends Tag> klass) {
        Tag tag = null;
        try {
            tag = klass.newInstance();
            tag.setTagName(tag.getTagName().toLowerCase());
            Tag endTag = klass.newInstance();
            endTag.setTagName("/" + tag.getTagName().toLowerCase());
            endTag.setParent((Node)tag);
            tag.setEndTag(endTag);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to create tag from class " + klass, e);
        }
        return tag;
    }

    private static String asHtml(String text) {
        if (HtmlTable.qualifiesAsHtml(text)) {
            if (HtmlTable.qualifiesAsSymbolReplacement(text)) {
                int contentOffset = text.indexOf(91);
                String assignment = text.substring(0, contentOffset);
                String content = text.substring(contentOffset);
                return HtmlUtil.escapeHTML(assignment) + content;
            }
            return text;
        }
        return HtmlUtil.escapeHTML(text);
    }

    @Override
    public HtmlTable asTemplate(Table.CellContentSubstitution substitution) throws SyntaxError {
        String script = this.toHtml();
        script = substitution.substitute(script);
        return new HtmlTableScanner(script).getTable(0);
    }

    static boolean qualifiesAsSymbolReplacement(String text) {
        return text.startsWith("$") && SYMBOL_REPLACEMENT_PATTERN.matcher(text).matches();
    }

    private static String[] parseSymbol(String text) {
        Matcher matcher = SYMBOL_REPLACEMENT_PATTERN.matcher(text);
        String[] symbols = new String[]{"", "", ""};
        if (matcher.matches()) {
            symbols[0] = matcher.group(1);
            symbols[1] = matcher.group(2);
            symbols[2] = matcher.group(3);
        } else {
            symbols[1] = text;
        }
        return symbols;
    }

    static boolean qualifiesAsHtml(String text) {
        return (text.startsWith("<") || text.startsWith("$")) && HTML_PATTERN.matcher(text).matches();
    }

    static class Cell {
        private final TableColumn columnNode;
        private final String originalContent;
        private SlimTestResult testResult;
        private ExceptionResult exceptionResult;

        public Cell(TableColumn tableColumn) {
            this.columnNode = tableColumn;
            this.originalContent = this.columnNode.getChildrenHTML();
        }

        public Cell(String contents) {
            if (contents == null) {
                contents = "";
            }
            TextNode text = new TextNode(contents);
            text.setChildren(new NodeList());
            this.columnNode = (TableColumn)HtmlTable.newTag(TableColumn.class);
            this.columnNode.setChildren(new NodeList((Node)text));
            this.originalContent = contents;
        }

        public String getContent() {
            String unescaped = this.columnNode.getChildrenHTML();
            if ("&nbsp;".equals(unescaped)) {
                return "";
            }
            return HtmlTable.qualifiesAsHtml(unescaped) ? unescaped : HtmlUtil.unescapeHTML(unescaped);
        }

        private void setContent(String s) {
            TextNode textNode = new TextNode(s);
            NodeList nodeList = new NodeList((Node)textNode);
            this.columnNode.setChildren(nodeList);
        }

        public String getTestResult() {
            return this.testResult != null ? this.testResult.toString(this.originalContent) : this.getContent();
        }

        public TableColumn getColumnNode() {
            return this.columnNode;
        }

        public void setTestResult(SlimTestResult testResult) {
            this.testResult = testResult;
        }

        public void setExceptionResult(ExceptionResult exceptionResult) {
            if (this.exceptionResult == null) {
                this.exceptionResult = exceptionResult;
                this.setContent(String.format("%s <span class=\"%s\">%s</span>", this.originalContent, exceptionResult.getExecutionResult().toString(), HtmlTable.asHtml(exceptionResult.getMessage())));
            }
        }

        public String formatTestResult() {
            if (this.testResult.getExecutionResult() == null) {
                return this.testResult.getMessage() != null ? HtmlTable.asHtml(this.testResult.getMessage()) : null;
            }
            String message = this.testResult.hasMessage() ? HtmlTable.asHtml(this.testResult.getMessage()) : this.originalContent;
            switch (this.testResult.getExecutionResult()) {
                case PASS: {
                    return String.format("<span class=\"pass\">%s</span>", message);
                }
                case FAIL: {
                    if (this.testResult.hasActual() && this.testResult.hasExpected()) {
                        if (HtmlTable.qualifiesAsHtml(this.testResult.getActual()) || HtmlTable.qualifiesAsHtml(this.testResult.getExpected())) {
                            return String.format("[%s] <span class=\"fail\">expected [%s]</span>", HtmlTable.asHtml(this.testResult.getActual()), HtmlTable.asHtml(this.testResult.getExpected()));
                        }
                        String[] actual = HtmlTable.parseSymbol(this.testResult.getActual());
                        String[] expected = HtmlTable.parseSymbol(this.testResult.getExpected());
                        return String.format("[%s] <span class=\"fail\">expected [%s]</span>", HtmlUtil.escapeHTML(actual[0]) + HtmlDiffUtil.buildActual(actual[1], expected[1]) + HtmlUtil.escapeHTML(actual[2]), HtmlUtil.escapeHTML(expected[0]) + new HtmlDiffUtil.ExpectedBuilder(this.testResult.getActual(), expected[1]).setOpeningTag("</span><span class=\"diff\">").setClosingTag("</span><span class=\"fail\">").build() + HtmlUtil.escapeHTML(expected[2]));
                    }
                    if ((this.testResult.hasActual() || this.testResult.hasExpected()) && this.testResult.hasMessage()) {
                        return String.format("[%s] <span class=\"fail\">%s</span>", HtmlTable.asHtml(this.testResult.hasActual() ? this.testResult.getActual() : this.testResult.getExpected()), message);
                    }
                    return String.format("<span class=\"fail\">%s</span>", message);
                }
                case IGNORE: {
                    if (this.testResult.doesCount()) {
                        return String.format("<span class=\"ignore\">%s</span>", message);
                    }
                    return String.format("%s <span class=\"ignore\">%s</span>", this.originalContent, message);
                }
                case ERROR: {
                    return String.format("%s <span class=\"error\">%s</span>", this.originalContent, message);
                }
            }
            return "Should not be here";
        }
    }

    class Row {
        private List<Cell> cells = new ArrayList<Cell>();
        private CompositeTag rowNode;

        public Row(CompositeTag rowNode) {
            this.rowNode = rowNode;
            NodeList nodeList = rowNode.getChildren();
            for (int i = 0; i < nodeList.size(); ++i) {
                Node node = nodeList.elementAt(i);
                if (!(node instanceof TableColumn)) continue;
                this.cells.add(new Cell((TableColumn)node));
            }
        }

        public Row() {
            this.rowNode = (TableRow)HtmlTable.newTag(TableRow.class);
            this.rowNode.setChildren(new NodeList());
            TableRow endNode = new TableRow();
            endNode.setTagName("/" + this.rowNode.getTagName().toLowerCase());
            this.rowNode.setEndTag((Tag)endNode);
        }

        public int getColumnCount() {
            return this.cells.size();
        }

        public Cell getColumn(int columnIndex) {
            return this.cells.get(columnIndex);
        }

        public void appendCell(String contents) {
            Cell newCell = new Cell(contents);
            this.appendCell(newCell);
        }

        private void appendCell(Cell newCell) {
            this.rowNode.getChildren().add((Node)newCell.getColumnNode());
            this.cells.add(newCell);
        }

        public CompositeTag getRowNode() {
            return this.rowNode;
        }

        private List<String> asList() {
            ArrayList<String> list = new ArrayList<String>();
            for (Cell cell : this.cells) {
                list.add(cell.getTestResult());
            }
            return list;
        }

        private void setExecutionResult(ExecutionResult executionResult) {
            NodeList cells = this.rowNode.getChildren();
            for (int i = 0; i < cells.size(); ++i) {
                Node cell = cells.elementAt(i);
                if (!(cell instanceof Tag)) continue;
                Tag tag = (Tag)cell;
                tag.setAttribute("class", executionResult.toString(), '\"');
            }
        }
    }
}

