/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ClassPath {
    private final List<String> elements;
    private final String separator;

    public ClassPath(List<String> elements, String separator) {
        this.elements = elements;
        this.separator = separator;
    }

    public ClassPath(String defaultPath, String pathSeparator) {
        this(Arrays.asList(defaultPath), pathSeparator);
    }

    public ClassPath(List<ClassPath> paths) {
        this.elements = new ArrayList<String>();
        this.separator = paths.get(0).getSeparator();
        for (ClassPath path : paths) {
            for (String element : path.getElements()) {
                if (this.elements.contains(element)) continue;
                this.elements.add(element);
            }
        }
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toString() {
        if (this.elements.isEmpty()) {
            return "defaultPath";
        }
        String result = StringUtils.join(this.elements, (String)this.separator);
        return result;
    }
}

