/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.SocketFactory;
import fitnesse.socketservice.SocketServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketService {
    private static final Logger LOG = Logger.getLogger(SocketService.class.getName());
    private final ServerSocket serverSocket;
    private final Thread serviceThread;
    private volatile boolean running = false;
    private final SocketServer server;
    private volatile boolean everRan = false;

    public SocketService(SocketServer server, boolean daemon, ServerSocket serverSocket) throws IOException {
        this.server = server;
        this.serverSocket = serverSocket;
        this.serviceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SocketService.this.serviceThread();
            }
        });
        this.serviceThread.setDaemon(daemon);
        this.serviceThread.start();
    }

    public void close() throws IOException {
        this.waitForServiceThreadToStart();
        this.running = false;
        this.serverSocket.close();
        try {
            this.serviceThread.join();
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Thread joining interrupted", e);
        }
    }

    private void waitForServiceThreadToStart() {
        if (this.everRan) {
            return;
        }
        while (!this.running) {
            Thread.yield();
        }
    }

    private void serviceThread() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.serverSocket.accept();
                if (!this.everRan) {
                    SocketFactory.printSocketInfo(s);
                }
                this.everRan = true;
                this.server.serve(s);
            }
            catch (OutOfMemoryError e) {
                LOG.log(Level.SEVERE, "Can't create new thread.  Out of Memory.  Aborting.", e);
                System.exit(99);
            }
            catch (SocketException sox) {
                this.running = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

