/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PacketResponder
implements SecureResponder {
    private SimpleResponse response;
    private WikiPage page;
    private JSONObject packet;
    List<JSONObject> tables = new ArrayList<JSONObject>();
    private String jsonpFunction;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.response = new SimpleResponse();
        this.jsonpFunction = request.getInput("jsonp");
        String pageName = request.getResource();
        PageCrawler pageCrawler = context.getRootPage().getPageCrawler();
        WikiPagePath resourcePath = PathParser.parse(pageName);
        this.page = pageCrawler.getPage(resourcePath);
        if (this.page == null) {
            this.response.setStatus(404);
        } else {
            this.buildPacket();
            this.response.setStatus(200);
        }
        return this.response;
    }

    private void buildPacket() {
        this.packet = new JSONObject();
        String html = this.page.getHtml();
        HtmlTableScanner scanner = new HtmlTableScanner(html);
        try {
            this.addTablesToPacket(scanner);
            if (this.jsonpFunction != null) {
                this.response.setContent(String.format("%s(%s)", this.jsonpFunction, this.packet.toString(1)));
            } else {
                this.response.setContent(this.packet.toString(1));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void addTablesToPacket(TableScanner scanner) throws JSONException {
        for (int i = 0; i < scanner.getTableCount(); ++i) {
            Object t = scanner.getTable(i);
            this.addTableToPacket((Table)t);
        }
        this.packet.put("tables", this.tables);
    }

    private void addTableToPacket(Table t) throws JSONException {
        JSONObject table = new JSONObject();
        JSONObject[] parents = new JSONObject[10];
        parents[0] = table;
        for (int row = 0; row < t.getRowCount(); ++row) {
            String value;
            List<String> rowList = this.getRowFromTable(t, row);
            int indent = this.getIndent(rowList);
            if (indent < 0) continue;
            String name = rowList.get(indent);
            String string = value = rowList.size() > indent + 1 ? rowList.get(indent + 1) : "";
            if (null == value || "".equals(value)) {
                JSONObject parent = new JSONObject();
                parents[indent].put(name, (Object)parent);
                parents[indent + 1] = parent;
                continue;
            }
            parents[indent].put(name, (Object)value);
        }
        this.tables.add(table);
    }

    private int getIndent(List<String> rowList) {
        for (int indent = 0; indent < rowList.size(); ++indent) {
            if ("".equals(rowList.get(indent))) continue;
            return indent;
        }
        return -1;
    }

    private List<String> getRowFromTable(Table t, int row) {
        ArrayList<String> rowList = new ArrayList<String>();
        for (int col = 0; col < t.getColumnCountInRow(row); ++col) {
            rowList.add(t.getCellContents(col, row));
        }
        return rowList;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

