/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.reporting.history.PageHistory;
import fitnesse.wiki.PathParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import util.FileUtil;

public class TestHistory {
    final Map<String, File> pageDirectoryMap = new HashMap<String, File>();

    public TestHistory(File historyDirectory) {
        this.readHistoryDirectory(historyDirectory);
    }

    public TestHistory(File historyDirectory, String pageName) {
        this.readPageHistoryDirectory(historyDirectory, pageName);
    }

    private void readHistoryDirectory(File historyDirectory) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing(historyDirectory)) {
            if (!this.isValidFile(file)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }

    private boolean isValidFile(File file) {
        return file.isDirectory() && file.list().length > 0 && PathParser.isWikiPath(file.getName());
    }

    public Set<String> getPageNames() {
        return new TreeSet<String>(this.pageDirectoryMap.keySet());
    }

    public PageHistory getPageHistory(String pageName) {
        File pageHistoryDirectory = this.pageDirectoryMap.get(pageName);
        if (pageHistoryDirectory == null) {
            return null;
        }
        PageHistory pageHistory = new PageHistory(pageHistoryDirectory);
        if (pageHistory.size() == 0) {
            return null;
        }
        return pageHistory;
    }

    private void readPageHistoryDirectory(File historyDirectory, String pageName) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing(historyDirectory)) {
            if (!this.isValidFile(file) || !file.getName().startsWith(pageName)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }
}

