/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.Authenticator;
import fitnesse.html.template.HtmlPage;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.util.Base64;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class NegotiateAuthenticator
extends Authenticator {
    public static final String NEGOTIATE = "Negotiate";
    protected String serviceName;
    protected Oid serviceNameType;
    protected Oid mechanism;
    protected boolean stripRealm = true;
    protected GSSManager manager;
    protected GSSCredential serverCreds;

    public NegotiateAuthenticator(GSSManager manager, Properties properties) throws Exception {
        this.manager = manager;
        this.configure(properties);
        this.initServiceCredentials();
    }

    public NegotiateAuthenticator(Properties properties) throws Exception {
        this(GSSManager.getInstance(), properties);
    }

    protected void initServiceCredentials() throws Exception {
        if (this.serviceName == null) {
            this.serverCreds = null;
        } else {
            GSSName name = this.manager.createName(this.serviceName, this.serviceNameType, this.mechanism);
            this.serverCreds = this.manager.createCredential(name, Integer.MAX_VALUE, this.mechanism, 2);
        }
    }

    protected void configure(Properties properties) throws Exception {
        this.serviceName = properties.getProperty("NegotiateAuthenticator.serviceName", null);
        this.serviceNameType = new Oid(properties.getProperty("NegotiateAuthenticator.serviceNameType", GSSName.NT_HOSTBASED_SERVICE.toString()));
        String mechanismProperty = properties.getProperty("NegotiateAuthenticator.mechanism", null);
        this.mechanism = mechanismProperty == null ? null : new Oid(mechanismProperty);
        this.stripRealm = Boolean.parseBoolean(properties.getProperty("NegotiateAuthenticator.stripRealm", "true"));
    }

    public GSSCredential getServerCredentials() {
        return this.serverCreds;
    }

    public Oid getServiceNameType() {
        return this.serviceNameType;
    }

    public Oid getMechanism() {
        return this.mechanism;
    }

    @Override
    protected Responder unauthorizedResponder(FitNesseContext context, Request request) {
        return new UnauthenticatedNegotiateResponder(request.getAuthorizationPassword());
    }

    protected void negotiateCredentials(Request request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.toLowerCase().startsWith(NEGOTIATE.toLowerCase())) {
            request.setCredentials(null, null);
        } else {
            try {
                this.setCredentials(request, NegotiateAuthenticator.getToken(authHeader));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to negotiate credentials", e);
            }
        }
    }

    static byte[] getToken(String authHeader) throws UnsupportedEncodingException {
        byte[] inputTokenEncoded = authHeader.substring(NEGOTIATE.length()).trim().getBytes("UTF-8");
        byte[] inputToken = Base64.decode(inputTokenEncoded);
        return inputToken;
    }

    private void setCredentials(Request request, byte[] inputToken) throws GSSException, UnsupportedEncodingException {
        String replyToken;
        GSSContext gssContext = this.manager.createContext(this.serverCreds);
        byte[] replyTokenBytes = gssContext.acceptSecContext(inputToken, 0, inputToken.length);
        String string = replyToken = replyTokenBytes == null ? null : new String(Base64.encode(replyTokenBytes), "UTF-8");
        if (!gssContext.isEstablished()) {
            request.setCredentials(null, replyToken);
        } else {
            int at;
            String authenticatedUser = ((Object)gssContext.getSrcName()).toString();
            if (this.stripRealm && (at = authenticatedUser.indexOf(64)) != -1) {
                authenticatedUser = authenticatedUser.substring(0, at);
            }
            request.setCredentials(authenticatedUser, replyToken);
        }
    }

    @Override
    public Responder authenticate(FitNesseContext context, Request request, Responder privilegedResponder) {
        this.negotiateCredentials(request);
        return super.authenticate(context, request, privilegedResponder);
    }

    @Override
    public boolean isAuthenticated(String username, String password) {
        return username != null;
    }

    protected static class UnauthenticatedNegotiateResponder
    implements Responder {
        private String token;

        public UnauthenticatedNegotiateResponder(String token) {
            this.token = token;
        }

        @Override
        public Response makeResponse(FitNesseContext context, Request request) {
            SimpleResponse response = new SimpleResponse(401);
            response.addHeader("WWW-Authenticate", this.token == null ? NegotiateAuthenticator.NEGOTIATE : "Negotiate " + this.token);
            HtmlPage html = context.pageFactory.newPage();
            html.addTitles("Negotiated authentication required");
            if (request == null) {
                html.setMainTemplate("authRequired.vm");
            } else {
                html.setMainTemplate("authFailed.vm");
            }
            response.setContent(html.html());
            return response;
        }
    }
}

