/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreParseElement;
import org.elasticsearch.search.rescore.RescoreSearchContext;

public class RescorePhase
extends AbstractComponent
implements SearchPhase {
    @Inject
    public RescorePhase(Settings settings) {
        super(settings);
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, RescoreParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("rescore", new RescoreParseElement());
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) throws ElasticsearchException {
        try {
            TopDocs topDocs = context.queryResult().topDocs();
            for (RescoreSearchContext ctx : context.rescore()) {
                topDocs = ctx.rescorer().rescore(topDocs, context, ctx);
            }
            context.queryResult().topDocs(topDocs);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", e);
        }
    }
}

