/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptMode;
import org.elasticsearch.script.ScriptService;

public class ScriptModes {
    static final String SCRIPT_SETTINGS_PREFIX = "script.";
    static final String ENGINE_SETTINGS_PREFIX = "script.engine";
    final ImmutableMap<String, ScriptMode> scriptModes;

    ScriptModes(Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, Settings settings, ESLogger logger) {
        HashMap<String, ScriptEngineService> filteredEngines = Maps.newHashMap(scriptEngines);
        filteredEngines.remove("native");
        this.scriptModes = ScriptModes.buildScriptModeSettingsMap(settings, filteredEngines, scriptContextRegistry, logger);
    }

    private static ImmutableMap<String, ScriptMode> buildScriptModeSettingsMap(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, ESLogger logger) {
        HashMap<String, ScriptMode> scriptModesMap = Maps.newHashMap();
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.FILE, ScriptMode.ON, scriptModesMap);
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INDEXED, ScriptMode.SANDBOX, scriptModesMap);
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INLINE, ScriptMode.SANDBOX, scriptModesMap);
        ArrayList<String> processedSettings = Lists.newArrayList();
        ScriptModes.processSourceBasedGlobalSettings(settings, scriptEngines, scriptContextRegistry, processedSettings, scriptModesMap);
        ScriptModes.processOperationBasedGlobalSettings(settings, scriptEngines, scriptContextRegistry, processedSettings, scriptModesMap);
        ScriptModes.processEngineSpecificSettings(settings, scriptEngines, scriptContextRegistry, processedSettings, scriptModesMap);
        ScriptModes.processDisableDynamicDeprecatedSetting(settings, scriptEngines, scriptContextRegistry, processedSettings, scriptModesMap, logger);
        return ImmutableMap.copyOf(scriptModesMap);
    }

    private static void processSourceBasedGlobalSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, List<String> processedSettings, Map<String, ScriptMode> scriptModes) {
        for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
            String scriptTypeSetting = settings.get(SCRIPT_SETTINGS_PREFIX + (Object)((Object)scriptType));
            if (!Strings.hasLength(scriptTypeSetting)) continue;
            ScriptMode scriptTypeMode = ScriptMode.parse(scriptTypeSetting);
            processedSettings.add(SCRIPT_SETTINGS_PREFIX + (Object)((Object)scriptType) + ": " + (Object)((Object)scriptTypeMode));
            ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, scriptType, scriptTypeMode, scriptModes);
        }
    }

    private static void processOperationBasedGlobalSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, List<String> processedSettings, Map<String, ScriptMode> scriptModes) {
        for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
            ScriptMode scriptMode = ScriptModes.getScriptContextMode(settings, SCRIPT_SETTINGS_PREFIX, scriptContext);
            if (scriptMode == null) continue;
            processedSettings.add(SCRIPT_SETTINGS_PREFIX + scriptContext.getKey() + ": " + (Object)((Object)scriptMode));
            ScriptModes.addGlobalScriptContextModes(scriptEngines.keySet(), scriptContext, scriptMode, scriptModes);
        }
    }

    private static void processEngineSpecificSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, List<String> processedSettings, Map<String, ScriptMode> scriptModes) {
        Map<String, Settings> langGroupedSettings = settings.getGroups(ENGINE_SETTINGS_PREFIX, true);
        for (Map.Entry<String, Settings> langSettings : langGroupedSettings.entrySet()) {
            ScriptEngineService scriptEngineService = scriptEngines.get(langSettings.getKey());
            if (scriptEngineService == null) continue;
            String enginePrefix = "script.engine." + langSettings.getKey() + ".";
            for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
                String scriptTypePrefix = (Object)((Object)scriptType) + ".";
                for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
                    ScriptMode scriptMode = ScriptModes.getScriptContextMode(langSettings.getValue(), scriptTypePrefix, scriptContext);
                    if (scriptMode == null) continue;
                    processedSettings.add(enginePrefix + scriptTypePrefix + scriptContext.getKey() + ": " + (Object)((Object)scriptMode));
                    ScriptModes.addScriptMode(scriptEngineService, scriptType, scriptContext, scriptMode, scriptModes);
                }
            }
        }
    }

    private static void processDisableDynamicDeprecatedSetting(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, List<String> processedSettings, Map<String, ScriptMode> scriptModes, ESLogger logger) {
        String disableDynamicSetting = settings.get("script.disable_dynamic");
        if (disableDynamicSetting != null) {
            if (processedSettings.isEmpty()) {
                ScriptService.DynamicScriptDisabling dynamicScriptDisabling = ScriptService.DynamicScriptDisabling.parse(disableDynamicSetting);
                switch (dynamicScriptDisabling) {
                    case EVERYTHING_ALLOWED: {
                        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INDEXED, ScriptMode.ON, scriptModes);
                        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INLINE, ScriptMode.ON, scriptModes);
                        break;
                    }
                    case ONLY_DISK_ALLOWED: {
                        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INDEXED, ScriptMode.OFF, scriptModes);
                        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INLINE, ScriptMode.OFF, scriptModes);
                    }
                }
                logger.warn("deprecated setting [{}] is set, replace with fine-grained scripting settings (e.g. script.inline, script.indexed, script.file)", "script.disable_dynamic");
            } else {
                processedSettings.add("script.disable_dynamic: " + disableDynamicSetting);
                throw new ElasticsearchIllegalArgumentException("conflicting scripting settings have been specified, use either script.disable_dynamic (deprecated) or the newer fine-grained settings (e.g. script.inline, script.indexed, script.file), not both at the same time:\n" + processedSettings);
            }
        }
    }

    private static ScriptMode getScriptContextMode(Settings settings, String prefix, ScriptContext scriptContext) {
        String settingValue = settings.get(prefix + scriptContext.getKey());
        if (Strings.hasLength(settingValue)) {
            return ScriptMode.parse(settingValue);
        }
        return null;
    }

    private static void addGlobalScriptTypeModes(Set<String> langs, ScriptContextRegistry scriptContextRegistry, ScriptService.ScriptType scriptType, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String lang : langs) {
            for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
                ScriptModes.addScriptMode(lang, scriptType, scriptContext, scriptMode, scriptModes);
            }
        }
    }

    private static void addGlobalScriptContextModes(Set<String> langs, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String lang : langs) {
            for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
                ScriptModes.addScriptMode(lang, scriptType, scriptContext, scriptMode, scriptModes);
            }
        }
    }

    private static void addScriptMode(ScriptEngineService scriptEngineService, ScriptService.ScriptType scriptType, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String scriptEngineName : scriptEngineService.types()) {
            ScriptModes.addScriptMode(scriptEngineName, scriptType, scriptContext, scriptMode, scriptModes);
        }
    }

    private static void addScriptMode(String lang, ScriptService.ScriptType scriptType, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        scriptModes.put("script.engine." + lang + "." + (Object)((Object)scriptType) + "." + scriptContext.getKey(), scriptMode);
    }

    public ScriptMode getScriptMode(String lang, ScriptService.ScriptType scriptType, ScriptContext scriptContext) {
        if ("native".equals(lang)) {
            return ScriptMode.ON;
        }
        ScriptMode scriptMode = this.scriptModes.get("script.engine." + lang + "." + (Object)((Object)scriptType) + "." + scriptContext.getKey());
        if (scriptMode == null) {
            throw new ElasticsearchIllegalArgumentException("script mode not found for lang [" + lang + "], script_type [" + (Object)((Object)scriptType) + "], operation [" + scriptContext.getKey() + "]");
        }
        return scriptMode;
    }

    public String toString() {
        TreeMap<String, ScriptMode> scriptModesTreeMap = new TreeMap<String, ScriptMode>();
        scriptModesTreeMap.putAll(this.scriptModes);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry stringScriptModeEntry : scriptModesTreeMap.entrySet()) {
            stringBuilder.append((String)stringScriptModeEntry.getKey()).append(": ").append(stringScriptModeEntry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }
}

