/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.transport.TransportRequest;

class RecoveryCleanFilesRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private Set<String> legacySnapshotFiles;
    private Store.MetadataSnapshot snapshotFiles;
    private int totalTranslogOps = -1;

    RecoveryCleanFilesRequest() {
    }

    RecoveryCleanFilesRequest(long recoveryId, ShardId shardId, Store.MetadataSnapshot snapshotFiles, int totalTranslogOps) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
        this.totalTranslogOps = totalTranslogOps;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        if (in.getVersion().onOrAfter(Version.V_1_5_0)) {
            this.snapshotFiles = new Store.MetadataSnapshot(in);
            this.totalTranslogOps = in.readVInt();
        } else {
            int size = in.readVInt();
            this.legacySnapshotFiles = Sets.newHashSetWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                this.legacySnapshotFiles.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_1_5_0)) {
            this.snapshotFiles.writeTo(out);
            out.writeVInt(this.totalTranslogOps);
        } else {
            out.writeVInt(this.snapshotFiles.size());
            for (StoreFileMetaData snapshotFile : this.snapshotFiles) {
                out.writeString(snapshotFile.name());
            }
        }
    }

    public Store.MetadataSnapshot sourceMetaSnapshot() {
        return this.snapshotFiles;
    }

    public Set<String> legacySnapshotFiles() {
        return this.legacySnapshotFiles;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }
}

