/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public interface FieldMapper<T>
extends Mapper {
    public static final String DOC_VALUES_FORMAT = "doc_values_format";

    public Names names();

    public FieldType fieldType();

    public float boost();

    public Analyzer indexAnalyzer();

    public Analyzer searchAnalyzer();

    public Analyzer searchQuoteAnalyzer();

    public SimilarityProvider similarity();

    public AbstractFieldMapper.CopyTo copyTo();

    public T value(Object var1);

    public Object valueForSearch(Object var1);

    public BytesRef indexedValueForSearch(Object var1);

    public boolean useTermQueryWithQueryString();

    public Query termQuery(Object var1, @Nullable QueryParseContext var2);

    public Filter termFilter(Object var1, @Nullable QueryParseContext var2);

    public Filter termsFilter(List var1, @Nullable QueryParseContext var2);

    public Filter fieldDataTermsFilter(List var1, @Nullable QueryParseContext var2);

    public Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public Filter rangeFilter(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public Query fuzzyQuery(String var1, Fuzziness var2, int var3, int var4, boolean var5);

    public Query prefixQuery(Object var1, @Nullable MultiTermQuery.RewriteMethod var2, @Nullable QueryParseContext var3);

    public Filter prefixFilter(Object var1, @Nullable QueryParseContext var2);

    public Query regexpQuery(Object var1, int var2, int var3, @Nullable MultiTermQuery.RewriteMethod var4, @Nullable QueryParseContext var5);

    public Filter regexpFilter(Object var1, int var2, int var3, @Nullable QueryParseContext var4);

    @Nullable
    public Query queryStringTermQuery(Term var1);

    @Nullable
    public Filter nullValueFilter();

    public FieldDataType fieldDataType();

    public PostingsFormatProvider postingsFormatProvider();

    public DocValuesFormatProvider docValuesFormatProvider();

    public boolean isNumeric();

    public boolean isSortable();

    public boolean supportsNullValue();

    public boolean hasDocValues();

    public Loading normsLoading(Loading var1);

    public boolean isGenerated();

    public FieldStats stats(Terms var1, int var2) throws IOException;

    public static enum Loading {
        LAZY{

            public String toString() {
                return Loading.LAZY_VALUE;
            }
        }
        ,
        EAGER{

            public String toString() {
                return Loading.EAGER_VALUE;
            }
        }
        ,
        EAGER_GLOBAL_ORDINALS{

            public String toString() {
                return Loading.EAGER_GLOBAL_ORDINALS_VALUE;
            }
        };

        public static final String KEY = "loading";
        public static final String EAGER_GLOBAL_ORDINALS_VALUE = "eager_global_ordinals";
        public static final String EAGER_VALUE = "eager";
        public static final String LAZY_VALUE = "lazy";

        public static Loading parse(String loading, Loading defaultValue) {
            if (Strings.isNullOrEmpty(loading)) {
                return defaultValue;
            }
            if (EAGER_GLOBAL_ORDINALS_VALUE.equalsIgnoreCase(loading)) {
                return EAGER_GLOBAL_ORDINALS;
            }
            if (EAGER_VALUE.equalsIgnoreCase(loading)) {
                return EAGER;
            }
            if (LAZY_VALUE.equalsIgnoreCase(loading)) {
                return LAZY;
            }
            throw new MapperParsingException("Unknown [loading] value: [" + loading + "]");
        }
    }

    public static class Names {
        private final String name;
        private final String indexName;
        private final String indexNameClean;
        private final String fullName;
        private final String sourcePath;

        public Names(String name) {
            this(name, name, name, name);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName) {
            this(name, indexName, indexNameClean, fullName, fullName);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName, @Nullable String sourcePath) {
            this.name = name;
            this.indexName = indexName;
            this.indexNameClean = indexNameClean;
            this.fullName = fullName;
            this.sourcePath = sourcePath == null ? this.fullName : sourcePath;
        }

        public String name() {
            return this.name;
        }

        public String indexName() {
            return this.indexName;
        }

        public String indexNameClean() {
            return this.indexNameClean;
        }

        public String fullName() {
            return this.fullName;
        }

        public String sourcePath() {
            return this.sourcePath;
        }

        public Term createIndexNameTerm(String value) {
            return new Term(this.indexName, value);
        }

        public Term createIndexNameTerm(BytesRef value) {
            return new Term(this.indexName, value);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Names names = (Names)o;
            if (!this.fullName.equals(names.fullName)) {
                return false;
            }
            if (!this.indexName.equals(names.indexName)) {
                return false;
            }
            if (!this.indexNameClean.equals(names.indexNameClean)) {
                return false;
            }
            if (!this.name.equals(names.name)) {
                return false;
            }
            return this.sourcePath.equals(names.sourcePath);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.indexName.hashCode();
            result = 31 * result + this.indexNameClean.hashCode();
            result = 31 * result + this.fullName.hashCode();
            result = 31 * result + this.sourcePath.hashCode();
            return result;
        }
    }
}

