/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.Uid;

final class ParentChildFilteredTermsEnum
extends FilteredTermsEnum {
    private final NavigableSet<BytesRef> parentTypes;
    private BytesRef seekTerm;
    private String type;
    private BytesRef id;

    ParentChildFilteredTermsEnum(TermsEnum tenum, NavigableSet<BytesRef> parentTypes) {
        super(tenum, true);
        this.parentTypes = parentTypes;
        this.seekTerm = parentTypes.isEmpty() ? null : (BytesRef)parentTypes.first();
    }

    protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
        BytesRef temp = this.seekTerm;
        this.seekTerm = null;
        return temp;
    }

    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
        if (this.parentTypes.isEmpty()) {
            return FilteredTermsEnum.AcceptStatus.END;
        }
        BytesRef[] typeAndId = Uid.splitUidIntoTypeAndId(term);
        if (this.parentTypes.contains(typeAndId[0])) {
            this.type = typeAndId[0].utf8ToString();
            this.id = typeAndId[1];
            return FilteredTermsEnum.AcceptStatus.YES;
        }
        BytesRef nextType = this.parentTypes.ceiling(typeAndId[0]);
        if (nextType == null) {
            return FilteredTermsEnum.AcceptStatus.END;
        }
        this.seekTerm = nextType;
        return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
    }

    public String type() {
        return this.type;
    }

    public BytesRef id() {
        return this.id;
    }
}

