/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.CustomBoostFactorScorer;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;
    float maxBoost = Float.MAX_VALUE;
    CombineFunction combineFunction;
    private Float minScore = null;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function, Float minScore) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function == null ? CombineFunction.MULT : function.getDefaultScoreCombiner();
        this.minScore = minScore;
    }

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function.getDefaultScoreCombiner();
    }

    public void setCombineFunction(CombineFunction combineFunction) {
        this.combineFunction = combineFunction;
    }

    public void setMaxBoost(float maxBoost) {
        this.maxBoost = maxBoost;
    }

    public float getMaxBoost() {
        return this.maxBoost;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight subQueryWeight = this.subQuery.createWeight(searcher);
        return new CustomBoostFactorWeight(subQueryWeight);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.subQuery.equals((Object)other.subQuery) && (this.function != null ? this.function.equals(other.function) : other.function == null) && this.maxBoost == other.maxBoost;
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * Objects.hashCode(this.function) ^ Float.floatToIntBits(this.getBoost());
    }

    static class FunctionFactorScorer
    extends CustomBoostFactorScorer {
        private final ScoreFunction function;

        private FunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreFunction function, float maxBoost, CombineFunction scoreCombiner, Float minScore) throws IOException {
            super(w, scorer, maxBoost, scoreCombiner, minScore);
            this.function = function;
        }

        @Override
        public float innerScore() throws IOException {
            float score = this.scorer.score();
            if (this.function == null) {
                return this.subQueryBoost * score;
            }
            return this.scoreCombiner.combine(this.subQueryBoost, score, this.function.score(this.scorer.docID(), score), this.maxBoost);
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;

        public CustomBoostFactorWeight(Weight subQueryWeight) throws IOException {
            this.subQueryWeight = subQueryWeight;
        }

        public Query getQuery() {
            return FunctionScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.subQueryWeight.getValueForNormalization();
            return sum *= FunctionScoreQuery.this.getBoost() * FunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.subQueryWeight.normalize(norm, topLevelBoost * FunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context, acceptDocs);
            if (subQueryScorer == null) {
                return null;
            }
            if (FunctionScoreQuery.this.function != null) {
                FunctionScoreQuery.this.function.setNextReader(context);
            }
            return new FunctionFactorScorer(this, subQueryScorer, FunctionScoreQuery.this.function, FunctionScoreQuery.this.maxBoost, FunctionScoreQuery.this.combineFunction, FunctionScoreQuery.this.minScore);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            if (FunctionScoreQuery.this.function != null) {
                FunctionScoreQuery.this.function.setNextReader(context);
                Explanation functionExplanation = FunctionScoreQuery.this.function.explainScore(doc, subQueryExpl);
                return FunctionScoreQuery.this.combineFunction.explain(FunctionScoreQuery.this.getBoost(), subQueryExpl, functionExplanation, FunctionScoreQuery.this.maxBoost);
            }
            return subQueryExpl;
        }
    }
}

