/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.collect.IdentityHashSet;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.jackson.core.JsonLocation;
import org.elasticsearch.common.joda.time.DateTimeFieldType;

public class ThrowableObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private static final Set<Class<?>> CLASS_WHITELIST;
    private static final Set<Package> PKG_WHITELIST;

    public ThrowableObjectInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public ThrowableObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        int version = this.readByte() & 0xFF;
        if (version != 5) {
            throw new StreamCorruptedException("Unsupported version: " + version);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int type = this.read();
        if (type < 0) {
            throw new EOFException();
        }
        switch (type) {
            case 2: {
                return ObjectStreamClass.lookup(Exception.class);
            }
            case 3: {
                return ObjectStreamClass.lookup(StackTraceElement.class);
            }
            case 0: {
                return this.verify(super.readClassDescriptor());
            }
            case 1: {
                String className = this.readUTF();
                Class<?> clazz = this.loadClass(className);
                return this.verify(ObjectStreamClass.lookup(clazz));
            }
        }
        throw new StreamCorruptedException("Unexpected class descriptor type: " + type);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        try {
            return this.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = Classes.getDefaultClassLoader();
        }
        Class<?> clazz = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
        return clazz;
    }

    private ObjectStreamClass verify(ObjectStreamClass streamClass) throws IOException, ClassNotFoundException {
        Class<?> aClass = this.resolveClass(streamClass);
        Package pkg = aClass.getPackage();
        if (aClass.isPrimitive() || aClass.isArray() || Throwable.class.isAssignableFrom(aClass) || CLASS_WHITELIST.contains(aClass) || PKG_WHITELIST.contains(aClass.getPackage()) || pkg.getName().startsWith("org.elasticsearch")) {
            return streamClass;
        }
        throw new NotSerializableException(aClass.getName());
    }

    static {
        IdentityHashSet<Class> classes = new IdentityHashSet<Class>();
        classes.add(String.class);
        classes.add(Inet6Address.class);
        classes.add(Inet4Address.class);
        classes.add(InetAddress.class);
        classes.add(InetSocketAddress.class);
        classes.add(SocketAddress.class);
        classes.add(StackTraceElement.class);
        classes.add(JsonLocation.class);
        IdentityHashSet<Package> packages = new IdentityHashSet<Package>();
        packages.add(Integer.class.getPackage());
        packages.add(List.class.getPackage());
        packages.add(ImmutableMap.class.getPackage());
        packages.add(DateTimeFieldType.class.getPackage());
        CLASS_WHITELIST = Collections.unmodifiableSet(classes);
        PKG_WHITELIST = Collections.unmodifiableSet(packages);
    }
}

