/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.termvector.MultiTermVectorsItemResponse;
import org.elasticsearch.action.termvector.MultiTermVectorsRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsResponse;
import org.elasticsearch.action.termvector.MultiTermVectorsShardRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsShardResponse;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TransportSingleShardMultiTermsVectorAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMultiTermVectorsAction
extends HandledTransportAction<MultiTermVectorsRequest, MultiTermVectorsResponse> {
    private final ClusterService clusterService;
    private final TransportSingleShardMultiTermsVectorAction shardAction;

    @Inject
    public TransportMultiTermVectorsAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportSingleShardMultiTermsVectorAction shardAction, ActionFilters actionFilters) {
        super(settings, "indices:data/read/mtv", threadPool, transportService, actionFilters);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
    }

    @Override
    protected void doExecute(MultiTermVectorsRequest request, final ActionListener<MultiTermVectorsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray<MultiTermVectorsItemResponse> responses = new AtomicArray<MultiTermVectorsItemResponse>(request.requests.size());
        HashMap<ShardId, MultiTermVectorsShardRequest> shardRequests = new HashMap<ShardId, MultiTermVectorsShardRequest>();
        for (int i = 0; i < request.requests.size(); ++i) {
            TermVectorRequest termVectorRequest = request.requests.get(i);
            termVectorRequest.startTime = System.currentTimeMillis();
            termVectorRequest.routing(clusterState.metaData().resolveIndexRouting(termVectorRequest.routing(), termVectorRequest.index()));
            if (!clusterState.metaData().hasConcreteIndex(termVectorRequest.index())) {
                responses.set(i, new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(termVectorRequest.index(), termVectorRequest.type(), termVectorRequest.id(), "[" + termVectorRequest.index() + "] missing")));
                continue;
            }
            String concreteSingleIndex = clusterState.metaData().concreteSingleIndex(termVectorRequest.index(), termVectorRequest.indicesOptions());
            if (termVectorRequest.routing() == null && clusterState.getMetaData().routingRequired(concreteSingleIndex, termVectorRequest.type())) {
                responses.set(i, new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(concreteSingleIndex, termVectorRequest.type(), termVectorRequest.id(), "routing is required for [" + concreteSingleIndex + "]/[" + termVectorRequest.type() + "]/[" + termVectorRequest.id() + "]")));
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, termVectorRequest.type(), termVectorRequest.id(), termVectorRequest.routing(), null).shardId();
            MultiTermVectorsShardRequest shardRequest = (MultiTermVectorsShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiTermVectorsShardRequest(request, shardId.index().name(), shardId.id());
                shardRequest.preference(request.preference);
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, termVectorRequest);
        }
        if (shardRequests.size() == 0) {
            listener.onResponse(new MultiTermVectorsResponse(responses.toArray(new MultiTermVectorsItemResponse[responses.length()])));
        }
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiTermVectorsShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiTermVectorsShardResponse>(){

                @Override
                public void onResponse(MultiTermVectorsShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        responses.set(response.locations.get(i), new MultiTermVectorsItemResponse(response.responses.get(i), response.failures.get(i)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    String message = ExceptionsHelper.detailedMessage(e);
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        TermVectorRequest termVectorRequest = shardRequest.requests.get(i);
                        responses.set(shardRequest.locations.get(i), new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(shardRequest.index(), termVectorRequest.type(), termVectorRequest.id(), message)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiTermVectorsResponse(responses.toArray(new MultiTermVectorsItemResponse[responses.length()])));
                }
            });
        }
    }

    @Override
    public MultiTermVectorsRequest newRequestInstance() {
        return new MultiTermVectorsRequest();
    }
}

