/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;

public class BulkRequest
extends ActionRequest<BulkRequest>
implements CompositeIndicesRequest {
    private static final int REQUEST_OVERHEAD = 50;
    final List<ActionRequest> requests = Lists.newArrayList();
    List<Object> payloads = null;
    protected TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;
    private boolean refresh = false;
    private long sizeInBytes = 0L;

    public BulkRequest add(ActionRequest ... requests) {
        for (ActionRequest request : requests) {
            this.add(request, (Object)null);
        }
        return this;
    }

    public BulkRequest add(ActionRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(ActionRequest request, @Nullable Object payload) {
        if (request instanceof IndexRequest) {
            this.add((IndexRequest)request, payload);
        } else if (request instanceof DeleteRequest) {
            this.add((DeleteRequest)request, payload);
        } else if (request instanceof UpdateRequest) {
            this.add((UpdateRequest)request, payload);
        } else {
            throw new ElasticsearchIllegalArgumentException("No support for request [" + request + "]");
        }
        return this;
    }

    public BulkRequest add(Iterable<ActionRequest> requests) {
        for (ActionRequest request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        return this.internalAdd(request, null);
    }

    public BulkRequest add(IndexRequest request, @Nullable Object payload) {
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(IndexRequest request, @Nullable Object payload) {
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += (long)(request.source().length() + 50);
        return this;
    }

    public BulkRequest add(UpdateRequest request) {
        request.beforeLocalFork();
        return this.internalAdd(request, null);
    }

    public BulkRequest add(UpdateRequest request, @Nullable Object payload) {
        request.beforeLocalFork();
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(UpdateRequest request, @Nullable Object payload) {
        this.requests.add(request);
        this.addPayload(payload);
        if (request.doc() != null) {
            this.sizeInBytes += (long)request.doc().source().length();
        }
        if (request.upsertRequest() != null) {
            this.sizeInBytes += (long)request.upsertRequest().source().length();
        }
        if (request.script() != null) {
            this.sizeInBytes += (long)(request.script().length() * 2);
        }
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DeleteRequest request, @Nullable Object payload) {
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += 50L;
        return this;
    }

    private void addPayload(Object payload) {
        if (this.payloads == null) {
            if (payload == null) {
                return;
            }
            this.payloads = new ArrayList<Object>(this.requests.size() + 10);
            for (int i = 1; i < this.requests.size(); ++i) {
                this.payloads.add(null);
            }
        }
        this.payloads.add(payload);
    }

    public List<ActionRequest> requests() {
        return this.requests;
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        ArrayList<IndicesRequest> indicesRequests = Lists.newArrayList();
        for (ActionRequest request : this.requests) {
            assert (request instanceof IndicesRequest);
            indicesRequests.add((IndicesRequest)((Object)request));
        }
        return indicesRequests;
    }

    @Nullable
    public List<Object> payloads() {
        return this.payloads;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    public BulkRequest add(byte[] data, int from, int length) throws Exception {
        return this.add(data, from, length, null, null);
    }

    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(new BytesArray(data, from, length), defaultIndex, defaultType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(data, defaultIndex, defaultType, null, null, true);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, boolean allowExplicitIndex) throws Exception {
        return this.add(data, defaultIndex, defaultType, null, null, allowExplicitIndex);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultRouting, @Nullable Object payload, boolean allowExplicitIndex) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data);
        int line = 0;
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            ++line;
            XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));
            Throwable throwable = null;
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                assert (token == XContentParser.Token.START_OBJECT);
                token = parser.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String action = parser.currentName();
                String index = defaultIndex;
                String type = defaultType;
                String id = null;
                String routing = defaultRouting;
                String parent = null;
                String timestamp = null;
                Long ttl = null;
                String opType = null;
                long version = -3L;
                VersionType versionType = VersionType.INTERNAL;
                int retryOnConflict = 0;
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if ("_index".equals(currentFieldName)) {
                                if (!allowExplicitIndex) {
                                    throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                }
                                index = parser.text();
                                continue;
                            }
                            if ("_type".equals(currentFieldName)) {
                                type = parser.text();
                                continue;
                            }
                            if ("_id".equals(currentFieldName)) {
                                id = parser.text();
                                continue;
                            }
                            if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                                routing = parser.text();
                                continue;
                            }
                            if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                                parent = parser.text();
                                continue;
                            }
                            if ("_timestamp".equals(currentFieldName) || "timestamp".equals(currentFieldName)) {
                                timestamp = parser.text();
                                continue;
                            }
                            if ("_ttl".equals(currentFieldName) || "ttl".equals(currentFieldName)) {
                                if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                                    ttl = TimeValue.parseTimeValue(parser.text(), null).millis();
                                    continue;
                                }
                                ttl = parser.longValue();
                                continue;
                            }
                            if ("op_type".equals(currentFieldName) || "opType".equals(currentFieldName)) {
                                opType = parser.text();
                                continue;
                            }
                            if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                                version = parser.longValue();
                                continue;
                            }
                            if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                                versionType = VersionType.fromString(parser.text());
                                continue;
                            }
                            if ("_retry_on_conflict".equals(currentFieldName) || "_retryOnConflict".equals(currentFieldName)) {
                                retryOnConflict = parser.intValue();
                                continue;
                            }
                            throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.VALUE_NULL) continue;
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]");
                    }
                } else if (token != XContentParser.Token.END_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + (Object)((Object)XContentParser.Token.START_OBJECT) + " or " + (Object)((Object)XContentParser.Token.END_OBJECT) + " but found [" + (Object)((Object)token) + "]");
                }
                if ("delete".equals(action)) {
                    this.add(new DeleteRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType), payload);
                    continue;
                }
                nextMarker = this.findNextMarker(marker, from, data, length);
                if (nextMarker == -1) break;
                ++line;
                if ("index".equals(action)) {
                    if (opType == null) {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).source(data.slice(from, nextMarker - from)), payload);
                    } else {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create("create".equals(opType)).source(data.slice(from, nextMarker - from)), payload);
                    }
                } else if ("create".equals(action)) {
                    this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create(true).source(data.slice(from, nextMarker - from)), payload);
                } else if ("update".equals(action)) {
                    IndexRequest doc;
                    UpdateRequest updateRequest = new UpdateRequest(index, type, id).routing(routing).parent(parent).retryOnConflict(retryOnConflict).version(version).versionType(versionType).routing(routing).parent(parent).source(data.slice(from, nextMarker - from));
                    IndexRequest upsertRequest = updateRequest.upsertRequest();
                    if (upsertRequest != null) {
                        upsertRequest.timestamp(timestamp);
                        upsertRequest.ttl(ttl);
                        upsertRequest.version(version);
                        upsertRequest.versionType(versionType);
                    }
                    if ((doc = updateRequest.doc()) != null) {
                        doc.timestamp(timestamp);
                        doc.ttl(ttl);
                        doc.version(version);
                        doc.versionType(versionType);
                    }
                    this.internalAdd(updateRequest, payload);
                }
                from = nextMarker + 1;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (parser == null) continue;
                if (throwable != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                parser.close();
            }
        }
        return this;
    }

    public BulkRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public BulkRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    @Deprecated
    public BulkRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    @Deprecated
    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public final BulkRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            ActionRequest request;
            byte type = in.readByte();
            if (type == 0) {
                request = new IndexRequest();
                ((IndexRequest)request).readFrom(in);
                this.requests.add(request);
                continue;
            }
            if (type == 1) {
                request = new DeleteRequest();
                ((DeleteRequest)request).readFrom(in);
                this.requests.add(request);
                continue;
            }
            if (type != 2) continue;
            request = new UpdateRequest();
            ((UpdateRequest)request).readFrom(in);
            this.requests.add(request);
        }
        this.refresh = in.readBoolean();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        out.writeVInt(this.requests.size());
        for (ActionRequest request : this.requests) {
            if (request instanceof IndexRequest) {
                out.writeByte((byte)0);
            } else if (request instanceof DeleteRequest) {
                out.writeByte((byte)1);
            } else if (request instanceof UpdateRequest) {
                out.writeByte((byte)2);
            }
            request.writeTo(out);
        }
        out.writeBoolean(this.refresh);
        this.timeout.writeTo(out);
    }
}

