/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.wrapper.StateChangeListener;
import org.rzo.yajsw.wrapper.WrappedRuntimeProcess;

public class RuntimeJavaMain {
    static boolean _stop = false;
    static boolean _debug = false;

    public static void main(String[] args) {
        _debug = "true".equals(System.getProperty("wrapper.debug", "false"));
        final WrappedRuntimeProcess p = new WrappedRuntimeProcess();
        Configuration conf = p.getConfiguration();
        RuntimeJavaMain.clearKeys(conf, "wrapper.control");
        RuntimeJavaMain.clearKeys(conf, "wrapper.console");
        RuntimeJavaMain.clearKeys(conf, "wrapper.logfile");
        RuntimeJavaMain.clearKeys(conf, "wrapper.on_exit");
        RuntimeJavaMain.clearKeys(conf, "wrapper.filter");
        RuntimeJavaMain.clearKeys(conf, "wrapper.tray");
        RuntimeJavaMain.clearKeys(conf, "wrapper.image.javawrapper");
        RuntimeJavaMain.clearKeys(conf, "wrapper.script");
        RuntimeJavaMain.clearKeys(conf, "wrapper.restart.reload_configuration");
        RuntimeJavaMain.clearKeys(conf, "wrapper.filter");
        RuntimeJavaMain.clearKeys(conf, "wrapper.java");
        RuntimeJavaMain.clearKeys(conf, "wrapper.console.visible");
        RuntimeJavaMain.clearKeys(conf, "wrapper.jvm_exit.timeout");
        RuntimeJavaMain.clearKeys(conf, "wrapper.service");
        conf.setProperty("wrapper.control", (Object)"APPLICATION");
        conf.setProperty("wrapper.console.loglevel", (Object)"INFO");
        conf.setProperty("wrapper.console.format", (Object)"ZM");
        conf.setProperty("wrapper.logfile.loglevel", (Object)"NONE");
        if ("true".equals(System.getProperty("wrapper.runtime.java.default.shutdown", "false"))) {
            conf.setProperty("wrapper.on_exit.default", (Object)"SHUTDOWN");
        }
        conf.setProperty("wrapper.console.pipestreams", (Object)"true");
        conf.setProperty("wrapper.console.visible", (Object)"true");
        conf.setProperty("wrapper.jvm_exit.timeout", (Object)0);
        conf.setProperty("wrapper.service", (Object)false);
        System.out.println("pipe streams: " + conf.getProperty("wrapper.console.pipestreams"));
        System.out.println("visible     : " + conf.getProperty("wrapper.console.visible"));
        RuntimeJavaMain.stopIfRunning(conf);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.err.println("Shutdown monitor started");
                while (p.isOSProcessRunning()) {
                    if (_debug) {
                        System.err.println("waiting for termination....");
                    }
                    RuntimeJavaMain.sleep(5000L);
                }
            }
        }));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.err.println("ShutdownHook started: stopping application");
                if (p.isOSProcessRunning()) {
                    if (_debug) {
                        System.err.println("runtime process warapper is shutting down, stopping runtime process");
                    }
                    p.stop();
                }
            }
        }));
        p.addStateChangeListener(0, new StateChangeListener(){

            @Override
            public void stateChange(int newState, int oldState) {
                int exitCode = p.getExitCode();
                if (_debug) {
                    System.err.println("wrapped runtime process stopped with exit code " + exitCode);
                }
                if (p.isOSProcessRunning()) {
                    p.shutdown();
                }
                System.exit(exitCode);
            }
        });
        p.start();
        RuntimeJavaMain.startTestThreadIfNeeded();
    }

    private static void stopIfRunning(Configuration conf) {
        int pid = -1;
        String file = conf.getString("wrapper.runtime.pidfile");
        if (file != null) {
            File f = new File(file);
            BufferedReader b = null;
            if (f.exists()) {
                try {
                    b = new BufferedReader(new FileReader(f));
                    pid = Integer.parseInt(b.readLine());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (b != null) {
                try {
                    b.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (pid == -1) {
                return;
            }
            Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
            if (p == null) {
                return;
            }
            String cmd = p.getCommand();
            if (cmd == null) {
                return;
            }
            String image = conf.getString("wrapper.image", null);
            if (!cmd.contains(image)) {
                return;
            }
            int timeout = conf.getInt("wrapper.shutdown.timeout", 30) * 1000;
            System.out.println("process with pid " + pid + " and cmd " + cmd + " is still running,stopping process with timeout of " + timeout + "ms");
            RuntimeJavaMain.sleep(3000L);
            p.stop(timeout, 999);
            RuntimeJavaMain.sleep(2000L);
        }
    }

    private static void clearKeys(Configuration conf, String key) {
        if (conf.containsKey(key)) {
            conf.clearProperty(key);
        }
        Iterator keys = conf.getKeys(key);
        while (keys.hasNext()) {
            conf.clearProperty((String)keys.next());
        }
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void startTestThreadIfNeeded() {
        if (Boolean.getBoolean("StopAfter30Sec")) {
            new Thread(){

                @Override
                public void run() {
                    RuntimeJavaMain.sleep(30000L);
                    System.exit(0);
                }
            }.start();
        }
    }
}

