/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw;

import com.sun.jna.PlatformEx;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.commons.cli2.validation.NumberValidator;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.rzo.yajsw.YajswVersion;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;
import org.rzo.yajsw.tools.ConfigGenerator;
import org.rzo.yajsw.tray.TrayIconMain;
import org.rzo.yajsw.util.MyKeyStoreInterface;
import org.rzo.yajsw.util.VFSFileValidator;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessFactory;
import org.rzo.yajsw.wrapper.WrappedProcessList;
import org.rzo.yajsw.wrapper.WrappedService;

public class WrapperExe {
    static Group group;
    static CommandLine cl;
    static String confFile;
    static List confFileList;
    static List properties;
    static List cmds;
    static int pid;
    static String defaultFile;
    static final int OPTION_C = 0;
    static final int OPTION_T = 1;
    static final int OPTION_P = 2;
    static final int OPTION_TX = 91;
    static final int OPTION_PX = 92;
    static final int OPTION_I = 3;
    static final int OPTION_R = 4;
    static final int OPTION_N = 5;
    static final int OPTION_G = 6;
    static final int OPTION_D = 7;
    static final int OPTION_Q = 8;
    static final int OPTION_QS = 9;
    static final int OPTION_Y = 10;
    static final int OPTION_QX = 11;
    static final int OPTION_RW = 12;
    static final int OPTION_K = 13;
    static final String ARGS = "arguments";
    static final String PID = "pid";
    static final String KS_KEY_VALUE = "ksKeyValue";
    static final String DEFAULT_FILE = "default configuration file";
    static WrappedService _service;
    static boolean _exitOnTerminate;
    static int _exitCode;
    static Map<String, Object> _properties;
    static List keyValue;

    private static WrappedService getService() {
        if (_service != null) {
            return _service;
        }
        WrapperExe.prepareProperties();
        _service = new WrappedService();
        if (confFileList != null && confFileList.size() > 1) {
            _service.setConfFilesList(confFileList);
        }
        _service.setLocalConfiguration((Configuration)new MapConfiguration(_properties));
        _service.init();
        return _service;
    }

    public static void main(String[] args) {
        System.out.println("YAJSW: yajsw-beta-12.04");
        System.out.println("OS   : " + YajswVersion.OS_VERSION);
        System.out.println("JVM  : " + YajswVersion.JAVA_VERSION);
        String wrapperJar = WrapperLoader.getWrapperJar();
        String homeDir = new File(wrapperJar).getParent();
        if (!OperatingSystem.instance().setWorkingDir(homeDir)) {
            System.out.println("could not set working dir, pls check configuration or user rights: " + homeDir);
        }
        WrapperExe.buildOptions();
        WrapperExe.parseCommand(args);
        if (cmds != null && cmds.size() > 0) {
            for (Object cmd : cmds) {
                if (!(cmd instanceof DefaultOption)) continue;
                WrapperExe.executeCommand((Option)cmd);
            }
        } else {
            WrapperExe.executeCommand(group.findOption("c"));
        }
        if (_exitOnTerminate) {
            Runtime.getRuntime().halt(_exitCode);
        }
    }

    private static File File(String property) {
        return null;
    }

    private static void executeCommand(Option cmd) {
        switch (cmd.getId()) {
            case 0: {
                WrapperExe.doConsole();
                break;
            }
            case 1: {
                WrapperExe.doStart();
                break;
            }
            case 2: {
                WrapperExe.doStop();
                break;
            }
            case 91: {
                WrapperExe.doStartPosix();
                break;
            }
            case 92: {
                WrapperExe.doStopPosix();
                break;
            }
            case 3: {
                WrapperExe.doInstall();
                break;
            }
            case 4: {
                WrapperExe.doRemove();
                break;
            }
            case 12: {
                WrapperExe.doRemoveWait();
                break;
            }
            case 5: {
                pid = ((Long)cl.getValue(cmd)).intValue();
                WrapperExe.doReconnect();
                break;
            }
            case 6: {
                pid = ((Long)cl.getValue(cmd)).intValue();
                WrapperExe.doGenerate();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                WrapperExe.doState();
                break;
            }
            case 9: {
                WrapperExe.doStateSilent();
            }
            case 11: {
                WrapperExe.doStatePosix();
                break;
            }
            case 10: {
                WrapperExe.doStartTrayIcon();
                break;
            }
            case 13: {
                keyValue = cl.getValues(cmd);
                WrapperExe.doAddKey();
                break;
            }
            default: {
                System.out.println("unimplemented option " + cmd.getPreferredName());
            }
        }
    }

    private static void doAddKey() {
        String key = (String)keyValue.get(0);
        String value = (String)keyValue.get(1);
        try {
            MyKeyStoreInterface ks = WrapperExe.getMyKeystore();
            ks.init();
            ks.put(key, value.toCharArray());
            System.out.println("added key " + key + " to keystore " + ks.getFile());
        }
        catch (Exception ex) {
            System.out.println("error storing data in keystore -> check folder or user rights");
            System.out.println(ex.getMessage());
        }
    }

    private static MyKeyStoreInterface getMyKeystore() throws Exception {
        Class<?> clazz = MyKeyStoreInterface.class.getClassLoader().loadClass("org.rzo.yajsw.util.MyKeyStore");
        return (MyKeyStoreInterface)clazz.newInstance();
    }

    private static void doReconnect() {
        WrapperExe.prepareProperties();
        MapConfiguration localConf = new MapConfiguration(_properties);
        YajswConfigurationImpl conf = new YajswConfigurationImpl((Configuration)localConf, true);
        WrappedProcess w = WrappedProcessFactory.createProcess(conf);
        System.out.println("************* RECONNECTING WRAPPER TO PID  " + pid + " ***********************");
        System.out.println();
        if (w.reconnect(pid)) {
            System.out.println("Connected to PID " + pid);
        } else {
            System.out.println("NOT connected to PID " + pid);
        }
        _exitOnTerminate = false;
    }

    private static void doRemove() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        System.out.println("************* REMOVING " + w.getServiceName() + " ***********************");
        System.out.println();
        boolean result = w.uninstall();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            System.out.println("Service " + w.getServiceName() + " removed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT removed");
        }
    }

    private static void doRemoveWait() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        System.out.println("************* REMOVING " + w.getServiceName() + " ***********************");
        System.out.println();
        boolean result = w.uninstall();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            while (w.isInstalled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            System.out.println("Service " + w.getServiceName() + " removed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT removed");
        }
    }

    private static void doInstall() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* INSTALLING " + w.getServiceName() + " ***********************");
        System.out.println();
        int i = 0;
        while (w.isInstalled() && i < 10) {
            if (PlatformEx.isWinVista() && w.requiresElevate()) {
                System.out.println("try uac elevate");
                WindowsXPProcess.elevateMe();
                return;
            }
            ++i;
            w.uninstall();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        boolean result = w.install();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            System.out.println("Service " + w.getServiceName() + " installed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT installed");
        }
    }

    private static void doStop() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STOPPING " + w.getServiceName() + " ***********************");
        System.out.println();
        try {
            w.stop();
            if (PlatformEx.isWinVista() && w.requiresElevate()) {
                System.out.println("try uac elevate");
                WindowsXPProcess.elevateMe();
                return;
            }
            if (w.isRunning()) {
                System.out.println("Service " + w.getServiceName() + " NOT stopped");
            } else {
                System.out.println("Service " + w.getServiceName() + " stopped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doStopPosix() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STOPPING " + w.getServiceName() + " ***********************");
        System.out.println();
        try {
            w.stopProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " stopped");
            _exitCode = 0;
            _exitOnTerminate = true;
        } else {
            System.out.println("Service" + w.getServiceName() + " NOT stopped");
            _exitCode = 1;
            _exitOnTerminate = true;
        }
    }

    private static void doStart() {
        WrappedService w = WrapperExe.getService();
        w.init();
        System.out.println("************* STARTING " + w.getServiceName() + " ***********************");
        System.out.println();
        w.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        int i = 0;
        while (!w.isRunning() && i++ < 30) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (w.isStarting()) continue;
        }
        if (w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " started");
            _exitCode = 0;
            _exitOnTerminate = true;
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT started");
            _exitCode = 1;
            _exitOnTerminate = true;
        }
    }

    private static void doStartPosix() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STARTING " + w.getServiceName() + " ***********************");
        System.out.println();
        w.startProcess();
        int i = 0;
        while (!w.isRunning() && i < 10) {
            ++i;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " started");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT started");
        }
        _exitOnTerminate = true;
    }

    private static void doStartTrayIcon() {
        WrapperExe.prepareProperties();
        String[] args = _service != null ? new String[]{_service.getConfigLocalPath()} : new String[]{confFile};
        try {
            TrayIconMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _exitOnTerminate = true;
    }

    private static void doState() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        int state = w.state();
        System.out.print("Name        : ");
        System.out.println(w.getServiceName());
        System.out.print("Installed   : ");
        System.out.println(w.isInstalled(state));
        System.out.print("Running     : ");
        System.out.println(w.isRunning(state));
        System.out.print("Interactive : ");
        System.out.println(w.isInteractive(state));
        System.out.print("Automatic   : ");
        System.out.println(w.isAutomatic(state));
        System.out.print("Manual      : ");
        System.out.println(w.isManual(state));
        System.out.print("Disabled    : ");
        System.out.println(w.isDisabled(state));
        System.out.print("Paused      : ");
        System.out.println(w.isPaused(state));
        System.out.print("Unknown      : ");
        System.out.println(w.isStateUnknown(state));
    }

    private static void doStateSilent() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        w.init();
        int state = w.state();
    }

    private static void doStatePosix() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        int state = w.state();
        _exitCode = w.isRunning(state) ? 0 : 3;
        _exitOnTerminate = true;
    }

    private static void doConsole() {
        WrapperExe.prepareProperties();
        WrappedProcessList list = WrappedProcessFactory.createProcessList(_properties, confFileList, true);
        list.startAll();
        _exitOnTerminate = false;
    }

    private static void doGenerate() {
        System.out.println("************* GENERATING YAJSW CONFIGURATION FOR PID " + pid + " ***********************");
        System.out.println();
        if (defaultFile != null) {
            ConfigGenerator.generate(pid, new File(defaultFile), new File(confFile));
        } else {
            ConfigGenerator.generate(pid, null, new File(confFile));
        }
    }

    private static void prepareProperties() {
        if (confFile != null) {
            _properties.put("wrapper.config", confFile);
        }
        if (defaultFile != null) {
            _properties.put("wrapperx.default.config", defaultFile);
        }
        if (properties != null) {
            for (String prop : properties) {
                String key = prop.substring(0, prop.indexOf(61));
                String value = prop.substring(prop.indexOf(61) + 1);
                _properties.put(key, value);
            }
        }
    }

    private static void parseCommand(String[] args) {
        Parser parser = new Parser();
        HelpFormatter hf = new HelpFormatter();
        DefaultOptionBuilder oBuilder = new DefaultOptionBuilder();
        Parser p = new Parser();
        p.setGroup(group);
        p.setHelpFormatter(hf);
        p.setHelpOption((Option)oBuilder.withLongName("help").withShortName("?").create());
        cl = p.parseAndHelp(args);
        if (cl == null) {
            System.exit(-1);
        }
        cmds = cl.getOptions();
        try {
            List arguments = cl.getValues(ARGS);
            properties = new ArrayList();
            confFileList = new ArrayList();
            for (Object obj : arguments) {
                String arg = (String)obj;
                if (Pattern.matches("wrapper\\..*=.*", arg)) {
                    properties.add(arg);
                    continue;
                }
                confFileList.add(arg);
            }
            if (confFileList.isEmpty()) {
                if (((Option)cmds.get(0)).getId() != 13) {
                    System.out.println("no wrapper config file found ");
                }
            } else {
                confFile = (String)confFileList.get(0);
            }
        }
        catch (Exception ex) {
            System.out.println("no wrapper config file found ");
        }
        try {
            defaultFile = (String)cl.getValue(cl.getOption("-d"));
            if (defaultFile != null) {
                defaultFile = new File(defaultFile).getCanonicalPath();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static void buildOptions() {
        DefaultOptionBuilder oBuilder = new DefaultOptionBuilder("-", "--", true);
        ArgumentBuilder aBuilder = new ArgumentBuilder();
        GroupBuilder gBuilder = new GroupBuilder();
        gBuilder.withOption((Option)oBuilder.reset().withId(0).withShortName("c").withLongName("console").withDescription("run as a Console application").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(1).withShortName("t").withLongName("start").withDescription("starT an NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(2).withShortName("p").withLongName("stop").withDescription("stoP a running NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(91).withShortName("tx").withLongName("startx").withDescription("starT -internal a Posix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(92).withShortName("px").withLongName("stopx").withDescription("stoP -internal- a running Posix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(3).withShortName("i").withLongName("install").withDescription("Install an NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(4).withShortName("r").withLongName("remove").withDescription("Remove an NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(12).withShortName("rw").withLongName("removeWait").withDescription("Remove an NT service or Unix daemon and wait until it is removed").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(8).withShortName("q").withLongName("query").withDescription("Query the status of an NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(10).withShortName("y").withLongName("tray").withDescription("Start System Tray Icon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(9).withShortName("qs").withLongName("querysilent").withDescription("Silent Query the status of an NT service or Unix daemon").create());
        gBuilder.withOption((Option)oBuilder.reset().withId(11).withShortName("qx").withLongName("queryposix").withDescription("Query the status of a posix daemon. Return status as exit code").create());
        Argument ksKey = aBuilder.reset().withName(KS_KEY_VALUE).withDescription("Key/Value in Keystore").withMinimum(2).withMaximum(2).create();
        gBuilder.withOption((Option)oBuilder.reset().withId(13).withShortName("k").withLongName("keystoreAdd").withDescription("Add Key/Value to Keystore").withArgument(ksKey).create());
        Argument pid = aBuilder.reset().withName(PID).withDescription("PID of process to reconnect to").withMinimum(1).withMaximum(1).withValidator((Validator)NumberValidator.getIntegerInstance()).create();
        gBuilder.withOption((Option)oBuilder.reset().withId(5).withShortName("n").withLongName("reconnect").withDescription("recoNnect to existing application").withArgument(pid).create());
        Argument pid2 = aBuilder.reset().withName(PID).withDescription("PID of process to reconnect to").withMinimum(1).withMaximum(1).withValidator((Validator)NumberValidator.getIntegerInstance()).create();
        Argument defaultFile = aBuilder.reset().withName(DEFAULT_FILE).withDescription("Default Configuration File").withMinimum(0).withMaximum(1).withValidator((Validator)VFSFileValidator.getExistingFileInstance().setBase(".")).create();
        gBuilder.withOption((Option)oBuilder.reset().withId(7).withShortName("d").withLongName("defaultConf").withDescription("Default Configuration File").withArgument(defaultFile).create());
        gBuilder.withOption((Option)oBuilder.reset().withId(6).withShortName("g").withLongName("genconf").withDescription("Generate configuration file from pid").withArgument(pid2).create());
        VFSFileValidator fValidator = VFSFileValidator.getExistingFileInstance().setBase(".");
        fValidator.setFile(false);
        gBuilder.withOption((Option)aBuilder.reset().withName(ARGS).withDescription("Arguments: a list of configuration files, for example conf/wrapper.conf followed by an optional list of configuration name-value pairs, for example wrapper.debug=true").withMinimum(0).create());
        gBuilder.withMaximum(3);
        group = gBuilder.create();
    }

    static {
        _service = null;
        _exitOnTerminate = true;
        _exitCode = 0;
        _properties = new HashMap<String, Object>();
    }
}

