/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.infinispan.schematic.internal.io.BufferCache;
import org.infinispan.schematic.internal.io.Utf8Util;

public class BsonDataInput
implements DataInput {
    private static final ThreadLocal<SoftReference<BufferCache>> BUFFER_CACHE = new ThreadLocal();
    private final DataInput input;
    private int total = 0;

    private static BufferCache getBufferCache() {
        SoftReference<BufferCache> ref = BUFFER_CACHE.get();
        if (ref == null || ref.get() == null) {
            ref = new SoftReference<BufferCache>(new BufferCache());
            BUFFER_CACHE.set(ref);
        }
        return ref.get();
    }

    public BsonDataInput(DataInput input) {
        this.input = input;
    }

    public int getTotalBytesRead() throws IOException {
        return this.total;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int b1 = this.input.readUnsignedByte();
        if (b1 == -1) {
            throw new EOFException();
        }
        ++this.total;
        return (byte)b1;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte b1 = (byte)this.readUnsignedByte();
        byte b2 = (byte)this.readUnsignedByte();
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        byte b1 = (byte)this.readUnsignedByte();
        byte b2 = (byte)this.readUnsignedByte();
        byte b3 = (byte)this.readUnsignedByte();
        byte b4 = (byte)this.readUnsignedByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        byte b1 = (byte)this.readUnsignedByte();
        byte b2 = (byte)this.readUnsignedByte();
        byte b3 = (byte)this.readUnsignedByte();
        byte b4 = (byte)this.readUnsignedByte();
        byte b5 = (byte)this.readUnsignedByte();
        byte b6 = (byte)this.readUnsignedByte();
        byte b7 = (byte)this.readUnsignedByte();
        byte b8 = (byte)this.readUnsignedByte();
        return ((long)b8 & 0xFFL) << 56 | ((long)b7 & 0xFFL) << 48 | ((long)b6 & 0xFFL) << 40 | ((long)b5 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b1 & 0xFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int read = this.read(b, off, len);
            if (read < 0) {
                throw new EOFException();
            }
            len -= read;
            off += read;
        }
    }

    protected int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            for (i = 0; i < len; ++i) {
                b[off + i] = this.read();
            }
        }
        catch (EOFException ee) {
            return -1;
        }
        return i;
    }

    protected final byte read() throws IOException {
        byte result = this.input.readByte();
        ++this.total;
        return result;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        int skipped = this.input.skipBytes(n);
        this.total += skipped;
        return skipped;
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readUTF(int len) throws IOException {
        return BsonDataInput.readUTF(this, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUTF(DataInput dis, int len) throws IOException {
        CharsetDecoder decoder = Utf8Util.CHARSET.newDecoder();
        BufferCache bufferCache = BsonDataInput.getBufferCache();
        ByteBuffer byteBuf = bufferCache.getByteBuffer(8384);
        CharBuffer charBuf = bufferCache.getCharBuffer(8384);
        try {
            byte[] bytes = byteBuf.array();
            while (len != 0 || byteBuf.position() > 0) {
                if (len < 0) {
                    while (byteBuf.remaining() != 0) {
                        byte b = dis.readByte();
                        if (b == 0) {
                            len = 0;
                            break;
                        }
                        byteBuf.put(b);
                    }
                    byteBuf.flip();
                } else if (len == 0) {
                    byteBuf.flip();
                } else {
                    int amountToRead = Math.min(len, byteBuf.remaining());
                    amountToRead = Math.min(amountToRead, charBuf.remaining());
                    int offset = byteBuf.position();
                    dis.readFully(bytes, offset, amountToRead);
                    byteBuf.limit(amountToRead);
                    byteBuf.rewind();
                    len -= amountToRead;
                }
                boolean endOfInput = len == 0;
                CoderResult result = decoder.decode(byteBuf, charBuf, endOfInput);
                if (result.isError()) {
                    result.throwException();
                } else if (result.isUnderflow()) {
                    byteBuf.compact();
                }
                if (len <= 0 || charBuf.remaining() != 0 && !result.isOverflow()) continue;
                int newBufferIncrement = len > 8384 ? 8384 : len;
                CharBuffer newBuffer = bufferCache.getCharBuffer(charBuf.capacity() + newBufferIncrement);
                charBuf.flip();
                newBuffer.put(charBuf);
                charBuf = newBuffer;
            }
            charBuf.flip();
            String string = charBuf.toString();
            return string;
        }
        finally {
            bufferCache.checkin(byteBuf);
            bufferCache.checkin(charBuf);
        }
    }
}

