/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.ssh.SshTunnelConnection;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overthere {
    private static final Logger logger = LoggerFactory.getLogger(Overthere.class);
    private static final AtomicReference<Map<String, Class<? extends OverthereConnectionBuilder>>> protocols = new AtomicReference(new HashMap());

    private static void boot() {
        Overthere.boot(new Scannit(Configuration.config().scan("com.xebialabs").with(new AbstractScanner[]{new TypeAnnotationScanner()})));
    }

    private static void boot(Scannit scannit) {
        Set protocolClasses = scannit.getTypesAnnotatedWith(Protocol.class);
        for (Class protocol : protocolClasses) {
            if (OverthereConnectionBuilder.class.isAssignableFrom(protocol)) {
                String name = protocol.getAnnotation(Protocol.class).name();
                protocols.get().put(name, protocol);
                continue;
            }
            logger.warn("Skipping class {} because it is not a HostConnectionBuilder.", (Object)protocol);
        }
    }

    private Overthere() {
    }

    public static OverthereConnection getConnection(String protocol, ConnectionOptions options) {
        if (!protocols.get().containsKey(protocol)) {
            throw new IllegalArgumentException("Unknown connection protocol " + protocol);
        }
        logger.trace("Connection for protocol {} requested with the following connection options: {}", (Object)protocol, (Object)options);
        ConnectionOptions jumpstationOptions = (ConnectionOptions)options.getOptional("jumpstation");
        AddressPortMapper mapper = DefaultAddressPortMapper.INSTANCE;
        if (jumpstationOptions != null) {
            mapper = (SshTunnelConnection)Overthere.getConnection("ssh", jumpstationOptions);
        }
        try {
            return Overthere.buildConnection(protocol, options, mapper);
        }
        catch (RuntimeException exc) {
            OverthereUtils.closeQuietly(mapper);
            throw exc;
        }
    }

    private static OverthereConnection buildConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        Class<? extends OverthereConnectionBuilder> connectionBuilderClass = protocols.get().get(protocol);
        try {
            Constructor<? extends OverthereConnectionBuilder> constructor = connectionBuilderClass.getConstructor(String.class, ConnectionOptions.class, AddressPortMapper.class);
            OverthereConnectionBuilder connectionBuilder = constructor.newInstance(protocol, options, mapper);
            if (connectionBuilder instanceof LocalConnection) {
                logger.debug("Connecting to {}", (Object)connectionBuilder);
            } else {
                logger.info("Connecting to {}", (Object)connectionBuilder);
            }
            OverthereConnection connection = connectionBuilder.connect();
            logger.trace("Connected to {}", (Object)connection);
            return connection;
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalStateException(connectionBuilderClass + " does not have a constructor that takes in a String and ConnectionOptions.", exc);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (InstantiationException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (InvocationTargetException exc) {
            if (exc.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exc.getCause();
            }
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
    }

    static {
        if (Scannit.isBooted()) {
            logger.info("Scannit already booted, checking to see whether it has scanned 'com.xebialabs'");
            Set protocols = Scannit.getInstance().getTypesAnnotatedWith(Protocol.class);
            if (!protocols.isEmpty()) {
                Overthere.boot(Scannit.getInstance());
            } else {
                Overthere.boot();
            }
        } else {
            Overthere.boot();
        }
    }
}

