#!/usr/bin/env python
import random

####################################################################################
# DO NOT EDIT WITHOUT FIXING THE UI TESTS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! #
# DO NOT ADD TEST SPECIFICATIONS / PROJECTS WIHTOUT UPDATING THE BOOTSTRAP LICENSE #
####################################################################################
FITNESSE_ROOT = 'testmaterials/fitnesse/FitNesseRoot'

DEMO_PROJECT = { 'id': '00000000-0000-0000-0000-000000000001', 'title': 'Example Pipeline' }

FUNCTIONAL_TESTS_FITNESSE = { 'id': '00000000-0000-0000-0000-000000000002', 'title': 'Functional tests' }
REGRESSION_TESTS_FITNESSE = { 'id': '00000000-0000-0000-0000-000000000003', 'title': 'Regression tests' }
END_TO_END_TESTS_CUCUMBER = { 'id': '00000000-0000-0000-0000-000000000004', 'title': 'End to end tests' }
PERFORMANCE_TESTS_GATLING = { 'id': '00000000-0000-0000-0000-000000000005', 'title': 'Performance tests' }
FUNCTIONAL_TESTS_SAVINGS_CUCUMBER = { 'id': '00000000-0000-0000-0000-000000000006', 'title': 'Functional tests savings' }
TEST_SET_FUNCTIONAL = { 'id': '00000000-0000-0000-0000-000000000009', 'title': 'All functional tests' }
TEST_SET_UNIT = { 'id': '00000000-0000-0000-0000-000000000010', 'title': 'All unit tests' }
TEST_SET_ALL = { 'id': '00000000-0000-0000-0000-000000000011', 'title': 'All tests' }

import time, os, os.path
from random import randint

from java.io import InputStreamReader, BufferedReader
from java.lang import Thread, System
from java.util import UUID
from org.joda.time import DateTime

from com.xebialabs.deployit.plugin.api.reflect import DescriptorRegistry, Type
from com.xebialabs.xltest.domain import EventHandler, Qualifier, QualificationResult
from com.xebialabs.xlt.plugin.api.testrun import Event
import com.xebialabs.xltest.domain.ActiveTestSpecification as TestSpecificationConst

DashboardTile = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.DashboardTile")).newInstance
Dashboard = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.Dashboard")).newInstance
LocalHost = DescriptorRegistry.getDescriptor(Type.valueOf("overthere.LocalHost")).newInstance
ExecutableTestSpecification = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.ShowCaseTestSpecification")).newInstance
SuperSet = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.TestSpecificationSet")).newInstance
Tag = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.Tag")).newInstance
Project = DescriptorRegistry.getDescriptor(Type.valueOf("xlt.Project")).newInstance

def resourcefile(name):
    loader = Thread.currentThread().getContextClassLoader()
    stream = loader.getResourceAsStream(name)
    # if not stream: raise StopIteration()
    reader = BufferedReader(InputStreamReader(stream))

    try:
        line = reader.readLine()
        yield line
        while line is not None:
            line = reader.readLine()
            yield line
    finally:
        reader.close()

# CONFIGURATION ITEMS #################
def store_Tag(title, color, tagId):
    id = str(UUID.randomUUID())

    tag = Tag('Configuration/Tags/' + id)
    tag.setColor(color)
    tag.setTitle(title)
    tag.setTagId(tagId)
    repository.createOrUpdate(tag)
    return tag

def store_Project(id, title):
    project = Project("Configuration/Projects/" + id)
    project.title = title
    repository.createOrUpdate(project)

def store_fitNesseTestSpecification(id, title, projectId):
    testSpecification = ExecutableTestSpecification('Configuration/Projects/' + projectId + '/' + id)
    testSpecification.title = title
    testSpecification.setProperty("scriptLocation", "xlt/ExecutableTestSpecification.py")
    # 'tags' property is a synthetic, so don't use the dot notation to set it!
    # testSpecification.setProperty('tags', 'team8')
    testSpecification.qualificationType = TestSpecificationConst.DEFAULT_FUNCTIONAL_TEST_QUALIFIER
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'xlt.FitNesse'
    testSpecification.searchPattern = '**/FitNesseRoot'
    localHost = LocalHost('Infrastructure/Hosts/XL TestView server')
    testSpecification.host = localHost
    localHost.os = operatingSystemFamily
    print "Operating system: " + operatingSystemFamily.toString()
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'java -jar plugins/fitnesse-20151230-standalone.jar -d testmaterials/fitnesse') +  ' -c "DemoSuite?suite&debug&format=text" '
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def osSpecificCommand(os, commandLine):
    if os.rfind("win") >= 0:
        commandLine = commandLine.replace("/", "\\")
        if commandLine.endswith('.sh'):
            commandLine = commandLine.replace(".sh", ".bat")
    return commandLine

def store_TestSpecificationSet(id, title, projectId, children):
    superTS = SuperSet('Configuration/Projects/' + projectId + '/' + id)
    superTS.title = title
    superTS.testSpecifications = children
    repository.createOrUpdate(superTS)
    return superTS

def store_cucumberTestSpecification(id, title, projectId):
    testSpecification = ExecutableTestSpecification('Configuration/Projects/' + projectId + '/' + id)
    testSpecification.title = title
    testSpecification.setProperty("scriptLocation", "xlt/ExecutableTestSpecification.py")
    os = System.getProperty("os.name").lower()
    testSpecification.searchPattern = '**/cucumber-report.json'
    testSpecification.qualificationType = TestSpecificationConst.DEFAULT_FUNCTIONAL_TEST_QUALIFIER
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'xlt.Cucumber'
    localHost = LocalHost('Infrastructure/Hosts/XL TestView server')
    localHost.os = operatingSystemFamily
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'testmaterials/cucumber/startCucumber.sh')
    testSpecification.timeout = 10
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def store_gatlingTestSpecification(id, title, projectId):
    testSpecification = ExecutableTestSpecification('Configuration/Projects/' + projectId + '/' + id)
    testSpecification.title = title
    testSpecification.setProperty("scriptLocation", "xlt/ExecutableTestSpecification.py")
    os = System.getProperty("os.name").lower()
    testSpecification.searchPattern = '**/simulation.log'
    testSpecification.qualificationType = TestSpecificationConst.DEFAULT_PERFORMANCE_TEST_QUALIFIER
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'xlt.Gatling'
    localHost = LocalHost('Infrastructure/Hosts/XL TestView server')
    localHost.os = operatingSystemFamily
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'testmaterials/gatling/startGatlingTest.sh')
    testSpecification.timeout = 10
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def store_JmeterTestSpecification(id, title, projectId):
    testSpecification = ExecutableTestSpecification('Configuration/Projects/' + projectId + '/' + id)
    testSpecification.title = title
    testSpecification.setProperty("scriptLocation", "xlt/ExecutableTestSpecification.py")
    os = System.getProperty("os.name").lower()
    testSpecification.searchPattern = '**/results*.csv'
    testSpecification.qualificationType = TestSpecificationConst.DEFAULT_PERFORMANCE_TEST_QUALIFIER
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'xlt.JMeterCSV'
    localHost = LocalHost('Infrastructure/Hosts/XL TestView server')
    localHost.os = operatingSystemFamily
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'testmaterials/jmeter/startJmeterTest.sh')
    testSpecification.timeout = 10
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def store_dashboards(testSpecificationId, project=DEMO_PROJECT):
    # NB create parent (== a directory), then create and save the holders, finally update the parent
    #    this order is required due to the 'asContainment' property of 'reportHolders' which in turn we
    #    need to send the whole parent/child relation to the UI in one go.
    testSpecification = repository.read(testSpecificationId)

    dashboard = Dashboard('Configuration/Dashboards/Demo_Dashboard')
    dashboard.setTitle('Demo Dashboard')
    repository.createOrUpdate(dashboard)
    barTile = DashboardTile(dashboard.id + '/barTile')
    barTile.title = 'Overview of test results (drill-down available)'
    barTile.x = 0
    barTile.y = 0
    barTile.w = 12
    barTile.h = 8
    barTile.reportType = "xlt.BarChart"
    barTile.testSpecification = testSpecification
    barTile.drillDownPrefix = "DemoSuite"
    healthTile = DashboardTile(dashboard.id + '/healthTile')
    healthTile.title = 'Test health barometer'
    healthTile.x = 0
    healthTile.y = 8
    healthTile.w = 8
    healthTile.h = 4
    healthTile.reportType = "xlt.HealthBarometer"
    healthTile.testSpecification = testSpecification
    healthTile.drillDownPrefix=""
    statsTile = DashboardTile(dashboard.id + '/statsTile')
    statsTile.title = 'Comparison of previous results'
    statsTile.x = 8
    statsTile.y = 8
    statsTile.w = 4
    statsTile.h = 4
    statsTile.reportType = "xlt.GeneralStatistics"
    statsTile.testSpecification = testSpecification
    statsTile.drillDownPrefix=""
    repository.createOrUpdate(barTile, healthTile, statsTile)
    dashboard.dashboardTiles = [barTile, healthTile, statsTile]
    repository.createOrUpdate(dashboard)

class MyEventHandler(EventHandler):
    def onReceive(self, event, testSpecificationId):
        extendedEvent = Event(event, {'@testSpecification' : testSpecificationId })
        store_event(extendedEvent.properties)

class MyQualifier(Qualifier):
    def getQualificationResult(self):
        return True
    def update(self, event):
        pass

# TEST RUNS #######################

def store_event(event):
    if event[Event.TYPE] and event[Event.RUN_ID] and event[Event.CREATED_AT] and event[Event.TEST_SPECIFICATION]:
        eventRepository.insert(Event(event))
    else:
        raise ValueError, 'Event invalid: ' + event


def iso_time(t):
    return time.strftime("%Y-%m-%dT%H:%M:%S", time.localtime(t))


def coerce(token):
    """
    Try to convert @token to a element in a more natural (parsed) from:

    >>> coerce("Str")
    'Str'
    >>> coerce("20")
    20

    :return:
    """
    try:
        return int(token)
    except ValueError:
        return token


def read_definitions():
    print 'reading definitions'
    import csv
    config = {}
    data = []
    # with open('definitions.csv', 'rb') as csvfile:
    csvfile = resourcefile('demodata/definitions.csv')
    print 'csvfile is', csvfile
    spamreader = csv.reader(csvfile, delimiter=',', quotechar='"')
    print 'csvfile is', csvfile

    mode = 'config'
    for row in spamreader:
        print row
        if not row or len(row) < 2 or not row[1]:
            continue

        # Check on section (column 1)
        if row[0] == 'config:':
            mode = 'config'
        elif row[0] == 'fitnesse:':
            mode = 'fitnesse'
            header = row[1:]
            continue

        # Handle data (column 2+)
        if mode == 'config':
            config[row[1]] = coerce(row[2])
        elif mode == 'fitnesse':
            data.append(dict(zip(header, map(coerce, row[1:]))))

    return config, data


def generate_permutations(definition, runId, timestamp, name, tags):
    ratio = 6
    for r in xrange(1, definition['test cases'] + 1):
        result = dict()
        result[Event.RUN_ID] = runId
        result[Event.TYPE] = Event.TYPE_FUNCTIONAL_RESULT
        result[Event.TEST_SPECIFICATION] = name
        duration = randint(definition['duration'] - definition['dt'], definition['duration'] + definition['dt'])
        result[Event.CREATED_AT] = int(timestamp) * 1000
        subSetSize = randint(0, len(tags))
        result['@tags'] = map(lambda x: x.tagId, random.sample(tags, subSetSize))
        result['@duration'] = duration
        timestamp = timestamp + duration
        result['@hierarchy'] = [ 'DemoSuite', definition['app name'], 'UseCase%03d' % (r / ratio + 1), 'UC%03d-TestCase%03d' % (r / ratio + 1, r % ratio + 1) ]
        if randint(0, 100) < definition['fault%']:
            result['wrong'] = randint(1, 2)
            result['right'] = 0
            result['@firstError'] = random.choice(['Database error, please check your logs for details', 'User interface did not respond', 'Too many requests', 'Timeout', 'NullPointerException', 'UnexpectedResultException: message is "Expected foo but got bar"'])
            result['@result'] = 'FAILED'
        else:
            result['right'] = randint(2, 3)
            result['wrong'] = 0
            result['@result'] = 'PASSED'
        yield result, int(timestamp) + duration

def createFitNesseSuitePageIfNeeded(directory):
    # directory is e.g. FitNesseRoot/DemoSuite/WebApp/UseCase001/TestCase003. Create for 'WebApp', 'UseCase001'
    dir = directory
    while os.path.dirname(dir) != FITNESSE_ROOT:
        dir = os.path.dirname(dir)
        file = dir + '/properties.xml'
        if not os.path.exists(file):
            with open(file,"w") as f:
                f.write('<?xml version="1.0"?>\n')
                f.write('<properties>\n')
                f.write('        <Edit/>\n')
                f.write('        <Files/>\n')
                f.write('        <Properties/>\n')
                f.write('        <RecentChanges/>\n')
                f.write('        <Refactor/>\n')
                f.write('        <Search/>\n')
                f.write('        <Suite/>\n')
                f.write('        <Suites></Suites>\n')
                f.write('        <Versions/>\n')
                f.write('        <WhereUsed/>\n')
                f.write('</properties>\n')

        file = dir + '/content.txt'
        if not os.path.exists(file):
            with open(file,"w") as f:
                f.write('!define TEST_SYSTEM {slim}\n')
                f.write('!contents -R2 -g -p -f -h\n')


def createFitNesseTestPage(hierarchy, result, right, wrong, team):
    directory = FITNESSE_ROOT + '/' + '/'.join(hierarchy)
    if not os.path.exists(directory):
        os.makedirs(directory)
    createFitNesseSuitePageIfNeeded(directory)
    file = directory + '/content.txt'
    if result == 'PASSED':
        passFail = 'succeed'
    else:
        passFail = 'fail'
    with open(file,"w") as f:
        f.write('Simple test. Should ' + passFail + ' without extra dependencies.\n')
        f.write('\n')
        f.write('| import |\n')
        f.write('| fitnesse.fixtures |\n')
        f.write('\n')
        f.write('| script | echo fixture |\n')
        if result == 'PASSED':
            for x in xrange(1, right):
                f.write('| check | echo | Hello World | Hello World |\n')
        else:
            for x in xrange(1, wrong):
                f.write('| check | echo | Hello World | Hello Universe |\n')

    file = directory + '/' + 'properties.xml'
    with open(file, "w") as f:
        f.write('<?xml version="1.0"?>\n')
        f.write('<properties>\n')
        f.write('    <Edit>true</Edit>\n')
        f.write('    <Files>true</Files>\n')
        f.write('    <Properties>true</Properties>\n')
        f.write('    <RecentChanges>true</RecentChanges>\n')
        f.write('    <Refactor>true</Refactor>\n')
        f.write('    <Search>true</Search>\n')
        f.write('    <Suites>team%s</Suites>\n' % team)
        f.write('    <Test/>\n')
        f.write('    <Versions>true</Versions>\n')
        f.write('    <WhereUsed>true</WhereUsed>\n')
        f.write('</properties>\n')


def fitnesse_result_event(event_type, runId, timestamp, name, custom):
    event = dict()
    event[Event.RUN_ID] = runId
    event[Event.CREATED_AT] = timestamp * 1000
    event[Event.TYPE] = event_type
    event[Event.TEST_SPECIFICATION] = name
    event.update(custom)
    return event

def parent_execution_event(event_type, runId, timestamp, custom):
    event = dict()
    event[Event.RUN_ID] = str(runId)
    event[Event.TYPE] = event_type
    event[Event.CREATED_AT] = timestamp * 1000
    event.update(custom)
    return event

def child_execution_started_event(parent_runId, runId, timestamp, custom):
    event = dict()
    event[Event.RUN_ID] = str(parent_runId)
    event[Event.CHILD_RUN_ID] = str(runId)
    event[Event.CREATED_AT] = timestamp * 1000
    event[Event.TYPE] = Event.CHILD_STARTED
    event.update(custom)
    return event

def test_execution_finished_event(parent_runId, runId, timestamp, custom):
    event = dict()
    event[Event.RUN_ID] = str(parent_runId)
    event[Event.CHILD_RUN_ID] = str(runId)
    event[Event.CREATED_AT] = timestamp * 1000
    event[Event.TYPE] = Event.CHILD_FINISHED
    event.update(custom)
    return event

def timer(days_back, interval=24*60*60):
    now = int(time.time())
    start_time = now - (days_back * interval)
    for ts in xrange(start_time, now, interval):
        yield ts


# Main ###############


config, definitions = read_definitions()
print "Configuration:", config
print "Definitions:", definitions


if "false" != System.getenv("DEV_DEMO_DATA"):

    # do not remember this so we can test filtering (ie no event should have this tag!)
    store_Tag("Fatal", "crimson", str(UUID.randomUUID()))

    # (used for uiTest!) do not remember this so we can test filtering (ie no event should have this tag!)
    store_Tag("DontUseMe", "dark-orchid", str(UUID.randomUUID()))
    tags = [ store_Tag("Connection", "gold", str(UUID.randomUUID())),
             store_Tag("Database", "dodger-blue", str(UUID.randomUUID())),
             store_Tag("UserError", "light-salmon", str(UUID.randomUUID())) ]

    store_Project(DEMO_PROJECT['id'], DEMO_PROJECT['title'])

    functionalTestsFitNesse = store_fitNesseTestSpecification(FUNCTIONAL_TESTS_FITNESSE['id'], FUNCTIONAL_TESTS_FITNESSE['title'], DEMO_PROJECT['id'])
    regressionTestsFitNesse = store_fitNesseTestSpecification(REGRESSION_TESTS_FITNESSE['id'], REGRESSION_TESTS_FITNESSE['title'], DEMO_PROJECT['id'])

    endToEndTestsCucumber = store_cucumberTestSpecification(END_TO_END_TESTS_CUCUMBER['id'], END_TO_END_TESTS_CUCUMBER['title'], DEMO_PROJECT['id'])

    testSetFunctional = store_TestSpecificationSet(TEST_SET_FUNCTIONAL['id'], TEST_SET_FUNCTIONAL['title'], DEMO_PROJECT['id'], [functionalTestsFitNesse, endToEndTestsCucumber])

    performanceTestsGatling = store_gatlingTestSpecification(PERFORMANCE_TESTS_GATLING['id'], PERFORMANCE_TESTS_GATLING['title'], DEMO_PROJECT['id'])

    testSetAll = store_TestSpecificationSet(TEST_SET_ALL['id'], TEST_SET_ALL['title'], DEMO_PROJECT['id'], [testSetFunctional, performanceTestsGatling])

    store_dashboards(functionalTestsFitNesse.id)

    for start_time in timer(config['runs']):
        runId = UUID.randomUUID().toString()
        print 'Generating test run', runId, 'for start time', time.ctime(start_time)
        finished_time = 0
        counter = 0
        store_event(fitnesse_result_event(Event.TYPE_IMPORT_STARTED, runId, start_time, functionalTestsFitNesse.name, {'@testedAt': start_time * 1000}))
        for definition in definitions:
            for result, finished_time in generate_permutations(definition, runId, start_time, functionalTestsFitNesse.name, tags):
                store_event(result)
                createFitNesseTestPage(result['@hierarchy'], result['@result'], result['right'], result['wrong'], definition['team'])
                counter = counter + 1
        store_event(fitnesse_result_event(Event.TYPE_IMPORT_FINISHED, runId, finished_time, functionalTestsFitNesse.name,
                                          {'@duration': (finished_time - start_time),"@size": counter + 2 }))
        result = QualificationResult.newInstance(functionalTestsFitNesse, runId)
        result.setResult(QualificationResult.Result.FAILED)
        result.setTime(DateTime.now())
        result.addFailureReason("Some tests failed during execution.")
        repository.createOrUpdate(result)

    cucumber_runId = UUID.randomUUID().toString()

    # Combine last run of the FitNesse demo suite with a cucumber run into a super
    parent_runId  = UUID.randomUUID().toString()
    store_event(parent_execution_event(Event.EXECUTION_STARTED, parent_runId, start_time, {'@testSpecification':TEST_SET_FUNCTIONAL['id']}))
    store_event(child_execution_started_event(parent_runId, runId, start_time, {'@testSpecification': TEST_SET_FUNCTIONAL['id']}))
    store_event(test_execution_finished_event(parent_runId, runId, finished_time, {'@testSpecification':TEST_SET_FUNCTIONAL['id']}))
    store_event(child_execution_started_event(parent_runId, cucumber_runId, start_time - 1000, {'@testSpecification':TEST_SET_FUNCTIONAL['id']}))
    store_event(test_execution_finished_event(parent_runId, cucumber_runId, start_time, {'@testSpecification':TEST_SET_FUNCTIONAL['id']}))
    store_event(parent_execution_event(Event.EXECUTION_FINISHED, parent_runId, finished_time, {'@testSpecification':TEST_SET_FUNCTIONAL['id']}))
