# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

paramDate = query_parameters.get('date') or ""
paramRange = query_parameters.get('range') or ""

REF_TMPL = '#/testspecifications/%s/report/xlt.TestRunEvents?runId=%s&date=%s&range=%s'
runs = test_runs.getTestRunsBetween(test_run.testSpecificationName, start_date.getTime(), end_date.getTime())
runs.reverse()

extraColumns = self.hasProperty('extraColumns') and self.getProperty('extraColumns') or []

def rowValues(run):
    return [ run.qualificationResult,
             { 'v': run.startTime.time, 'ref': REF_TMPL % (run.testSpecificationName, run.id, paramDate, paramRange) },
             run.duration if run.finished else 'in progress'] + \
         [run.getParameter(col) for col in extraColumns]

result_holder.result = {
    'title':'Test run overview',
    'description': 'This report shows the test runs performed in the defined period.',
    'header': [
        { 'name': '', 'kind': 'qualification'},
        { 'name': 'Start date', 'kind': 'date'},
        { 'name': 'Duration (s)', 'kind': 'duration'}
    ] + [ { 'name': str(col).title() } for col in extraColumns ],
    'body': [
        rowValues(run) for run in runs
    ]
}
