# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from itertools import groupby
from operator import itemgetter

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

def duration_trend(series):
    return {
        'chart': {
        },
        'credits': {
            'enabled': False
        },
        'colors': ['#FFA500', '#69B749', '#4AA0C8', '#FCD364', '#8E2800', '#B85C5A', '#644D52', '#BEEB9F', '#7E827A', '#468966', '#F77A52', '#35203B', '#88A825', '#FF6F69', '#445878', '#FFE11A', '#FF8598', '#7E8AA2', '#45BF55', '#7FB2F0'],
        'tooltip': {
            'pointFormat': '{series.name}: <b>{point.y}</b>'
        },
        'labels': {
            'enabled': False
        },
        'legend': {
            'enabled': False
        },
        'xAxis': {
            'type': 'datetime',
            'title': None
        },
        'yAxis': {
            'labels': {
                'format': '{value} ms',
            },
            'title': None,
        }, 
        'plotOptions': {
                'series':  {
                    'marker':{'symbol': 'circle'},
                    'point': {
                        'events': { 'click': 'url'}
                    }
                } or None
        },
        'series': series
    }

title = self.label
maxRunsInHistory = self.getProperty('maxRunsInHistory')
found_import_events = test_runs.getEventsBetween(start_date.getTime(), end_date.getTime(), {'@testSpecification': test_run.getTestSpecificationName(), '@type': 'importStarted'})
testrun_vs_lastmodified = {event.get('@runId'):event.get('@testedAt') for event in found_import_events}

level = len(prefixArray)

by_name = itemgetter(0)
by_last_modified = itemgetter(1)
by_duration = itemgetter(2)

found_events = test_runs.getEventsBetween(start_date.getTime(), end_date.getTime(), {'@testSpecification': test_run.getTestSpecificationName(), '@type': 'functionalResult', '@tags': tags or []})

triplets = [(
                tuple(event.get('@hierarchy')[:(level + 1)]),
                testrun_vs_lastmodified.get(event.get('@runId')),
                event.get('@duration') if event.get('@duration') else 0
            ) for event in found_events if prefix_within_hierarchy(event, prefixArray)]

triplets.sort()

series = []
subsuites = []
for name, lastmod_dur in groupby(triplets, by_name):
    suiteName = ';'.join(name)
    s = [ {'x':lastModifiedTime, 'y':sum(map(by_duration, durs)), 'params': {'prefix': suiteName}} for lastModifiedTime, durs in groupby(lastmod_dur, by_last_modified) if lastModifiedTime ]
    series.append({'name': suiteName, 'data': s })

    subsuites.append(get_suite_name(name))

print "series", series

parentSuite = get_parent_suite(prefixArray)
suiteName = get_suite_name(prefixArray)

maxRunsInHistory = len(testrun_vs_lastmodified)


report = {
    'title': title,
    'description': 'This report shows the trend in the time required to execute the test specification.\nClick a point in the report to go down one level. Use the breadcrumbs to go up.',
    'parentSuite': parentSuite,
    'maxRunsInHistory': maxRunsInHistory,
    'bottomRight': duration_trend(series),
    'subsuites': subsuites,
    'suiteName': suiteName
}

result_holder.result = report
