/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.status;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestIndicesStatusAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestIndicesStatusAction(Settings settings, RestController controller, Client client, SettingsFilter settingsFilter) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_status", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_status", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        IndicesStatusRequest indicesStatusRequest = new IndicesStatusRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesStatusRequest.listenerThreaded(false);
        indicesStatusRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesStatusRequest.indicesOptions()));
        indicesStatusRequest.recovery(request.paramAsBoolean("recovery", indicesStatusRequest.recovery()));
        indicesStatusRequest.snapshot(request.paramAsBoolean("snapshot", indicesStatusRequest.snapshot()));
        client.admin().indices().status(indicesStatusRequest, (ActionListener<IndicesStatusResponse>)new RestBuilderListener<IndicesStatusResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesStatusResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, response);
                response.toXContent(builder, request, RestIndicesStatusAction.this.settingsFilter);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

