/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.IntOpenHashSet;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.aliases.IndexAlias;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent<IndicesClusterStateService>
implements ClusterStateListener {
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final RecoveryTarget recoveryTarget;
    private final ShardStateAction shardStateAction;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    private final NodeMappingRefreshAction nodeMappingRefreshAction;
    private final ConcurrentMap<Tuple<String, String>, Boolean> seenMappings = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, FailedShard> failedShards = ConcurrentCollections.newConcurrentMap();
    private final Object mutex = new Object();
    private final FailedEngineHandler failedEngineHandler = new FailedEngineHandler();
    private final boolean sendRefreshMapping;

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, RecoveryTarget recoveryTarget, ShardStateAction shardStateAction, NodeIndexDeletedAction nodeIndexDeletedAction, NodeMappingRefreshAction nodeMappingRefreshAction) {
        super(settings);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoveryTarget = recoveryTarget;
        this.shardStateAction = shardStateAction;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        this.nodeMappingRefreshAction = nodeMappingRefreshAction;
        this.sendRefreshMapping = this.componentSettings.getAsBoolean("send_refresh_mapping", (Boolean)true);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.clusterService.addFirst(this);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        if (!this.lifecycle.started()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (event.state().blocks().disableStatePersistence()) {
                for (IndexService indexService : this.indicesService) {
                    String index = indexService.index().getName();
                    for (Integer shardId : indexService.shardIds()) {
                        this.logger.debug("[{}][{}] removing shard (disabled block persistence)", index, shardId);
                        try {
                            indexService.removeShard(shardId, "removing shard (disabled block persistence)");
                        }
                        catch (Throwable e) {
                            this.logger.warn("[{}] failed to remove shard (disabled block persistence)", e, index);
                        }
                    }
                    this.removeIndex(index, "cleaning index (disabled block persistence)");
                }
                return;
            }
            this.cleanFailedShards(event);
            this.applyDeletedIndices(event);
            this.applyNewIndices(event);
            this.applyMappings(event);
            this.applyAliases(event);
            this.applyNewOrUpdatedShards(event);
            this.applyDeletedShards(event);
            this.applyCleanedIndices(event);
            this.applySettings(event);
        }
    }

    private void applyCleanedIndices(ClusterChangedEvent event) {
        String index;
        for (IndexService indexService : this.indicesService) {
            index = indexService.index().getName();
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null || indexMetaData.state() != IndexMetaData.State.CLOSE) continue;
            for (Integer shardId : indexService.shardIds()) {
                this.logger.debug("[{}][{}] removing shard (index is closed)", index, shardId);
                try {
                    indexService.removeShard(shardId, "removing shard (index is closed)");
                }
                catch (Throwable e) {
                    this.logger.warn("[{}] failed to remove shard (index is closed)", e, index);
                }
            }
        }
        for (IndexService indexService : this.indicesService) {
            index = indexService.index().getName();
            if (!indexService.shardIds().isEmpty()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index (no shards allocated)", index);
            }
            this.removeIndex(index, "removing index (no shards allocated)");
        }
    }

    private void applyDeletedIndices(ClusterChangedEvent event) {
        ClusterState previousState = event.previousState();
        String localNodeId = event.state().nodes().localNodeId();
        assert (localNodeId != null);
        for (IndexService indexService : this.indicesService) {
            IndexMetaData indexMetaData = event.state().metaData().index(indexService.index().name());
            if (indexMetaData == null || indexMetaData.isSameUUID(indexService.indexUUID())) continue;
            this.logger.debug("[{}] mismatch on index UUIDs between cluster state and local state, cleaning the index so it will be recreated", indexMetaData.index());
            this.deleteIndex(indexMetaData.index(), "mismatch on index UUIDs between cluster state and local state, cleaning the index so it will be recreated");
        }
        for (String index : event.indicesDeleted()) {
            Settings indexSettings;
            IndexService idxService;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index, no longer part of the metadata", index);
            }
            if ((idxService = this.indicesService.indexService(index)) != null) {
                indexSettings = idxService.getIndexSettings();
                this.deleteIndex(index, "index no longer part of the metadata");
            } else {
                IndexMetaData metaData = previousState.metaData().index(index);
                assert (metaData != null);
                indexSettings = metaData.settings();
                this.indicesService.deleteClosedIndex("closed index no longer part of the metadata", metaData, event.state());
            }
            try {
                this.nodeIndexDeletedAction.nodeIndexDeleted(event.state(), index, indexSettings, localNodeId);
            }
            catch (Throwable e) {
                this.logger.debug("failed to send to master index {} deleted event", e, index);
            }
        }
    }

    private void applyDeletedShards(ClusterChangedEvent event) {
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            return;
        }
        IntOpenHashSet newShardIds = new IntOpenHashSet();
        for (IndexService indexService : this.indicesService) {
            String index = indexService.index().name();
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null) continue;
            newShardIds.clear();
            for (MutableShardRouting shard : routingNode) {
                if (!shard.index().equals(index)) continue;
                newShardIds.add(shard.id());
            }
            for (Integer existingShardId : indexService.shardIds()) {
                if (newShardIds.contains(existingShardId)) continue;
                if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}][{}] removing shard (index is closed)", index, existingShardId);
                    }
                    indexService.removeShard(existingShardId, "removing shard (index is closed)");
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] removing shard (not allocated)", index, existingShardId);
                }
                indexService.removeShard(existingShardId, "removing shard (not allocated)");
            }
        }
    }

    private void applyNewIndices(ClusterChangedEvent event) {
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            return;
        }
        for (MutableShardRouting shard : routingNode) {
            if (this.indicesService.hasIndex(shard.index())) continue;
            IndexMetaData indexMetaData = event.state().metaData().index(shard.index());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] creating index", indexMetaData.index());
            }
            try {
                this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), event.state().nodes().localNode().id());
            }
            catch (Throwable e) {
                this.sendFailShard(shard, indexMetaData.getUUID(), "failed to create index", e);
            }
        }
    }

    private void applySettings(ClusterChangedEvent event) {
        if (!event.metaDataChanged()) {
            return;
        }
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            String index;
            IndexService indexService;
            if (!this.indicesService.hasIndex(indexMetaData.index()) || !event.indexMetaDataChanged(indexMetaData) || (indexService = this.indicesService.indexService(index = indexMetaData.index())) == null) continue;
            IndexSettingsService indexSettingsService = indexService.injector().getInstance(IndexSettingsService.class);
            indexSettingsService.refreshSettings(indexMetaData.settings());
        }
    }

    private void applyMappings(ClusterChangedEvent event) {
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            if (!this.indicesService.hasIndex(indexMetaData.index())) continue;
            ArrayList<String> typesToRefresh = Lists.newArrayList();
            String index = indexMetaData.index();
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                return;
            }
            try {
                boolean requireRefresh;
                MapperService mapperService = indexService.mapperService();
                if (indexMetaData.mappings().containsKey("_default_") && (requireRefresh = this.processMapping(index, mapperService, "_default_", indexMetaData.mapping("_default_").source()))) {
                    typesToRefresh.add("_default_");
                }
                for (ObjectCursor objectCursor : indexMetaData.mappings().values()) {
                    boolean requireRefresh2;
                    MappingMetaData mappingMd = (MappingMetaData)objectCursor.value;
                    String mappingType = mappingMd.type();
                    CompressedString mappingSource = mappingMd.source();
                    if (mappingType.equals("_default_") || !(requireRefresh2 = this.processMapping(index, mapperService, mappingType, mappingSource))) continue;
                    typesToRefresh.add(mappingType);
                }
                if (!typesToRefresh.isEmpty() && this.sendRefreshMapping) {
                    this.nodeMappingRefreshAction.nodeMappingRefresh(event.state(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(index, indexMetaData.uuid(), typesToRefresh.toArray(new String[typesToRefresh.size()]), event.state().nodes().localNodeId()));
                }
                for (DocumentMapper documentMapper : mapperService.docMappers(true)) {
                    if (!this.seenMappings.containsKey(new Tuple<String, String>(index, documentMapper.type())) || indexMetaData.mappings().containsKey(documentMapper.type())) continue;
                    mapperService.remove(documentMapper.type());
                    this.seenMappings.remove(new Tuple<String, String>(index, documentMapper.type()));
                }
            }
            catch (Throwable t) {
                for (IndexShard indexShard : indexService) {
                    ShardRouting shardRouting = indexShard.routingEntry();
                    this.failAndRemoveShard(shardRouting, indexService, true, "failed to update mappings", t);
                }
            }
        }
    }

    private boolean processMapping(String index, MapperService mapperService, String mappingType, CompressedString mappingSource) throws Throwable {
        if (!this.seenMappings.containsKey(new Tuple<String, String>(index, mappingType))) {
            this.seenMappings.put(new Tuple<String, String>(index, mappingType), true);
        }
        boolean requiresRefresh = false;
        try {
            if (!mapperService.hasMapping(mappingType)) {
                if (this.logger.isDebugEnabled() && mappingSource.compressed().length < 512) {
                    this.logger.debug("[{}] adding mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}] adding mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                } else {
                    this.logger.debug("[{}] adding mapping [{}] (source suppressed due to length, use TRACE level if needed)", index, mappingType);
                }
                mapperService.merge(mappingType, mappingSource, false);
                if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                    this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    requiresRefresh = true;
                }
            } else {
                DocumentMapper existingMapper = mapperService.documentMapper(mappingType);
                if (!mappingSource.equals(existingMapper.mappingSource())) {
                    if (this.logger.isDebugEnabled() && mappingSource.compressed().length < 512) {
                        this.logger.debug("[{}] updating mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.trace("[{}] updating mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                    } else {
                        this.logger.debug("[{}] updating mapping [{}] (source suppressed due to length, use TRACE level if needed)", index, mappingType);
                    }
                    mapperService.merge(mappingType, mappingSource, false);
                    if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                        requiresRefresh = true;
                        this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("[{}] failed to add mapping [{}], source [{}]", e, index, mappingType, mappingSource);
            throw e;
        }
        return requiresRefresh;
    }

    private boolean aliasesChanged(ClusterChangedEvent event) {
        return !event.state().metaData().aliases().equals(event.previousState().metaData().aliases()) || !event.state().routingTable().equals(event.previousState().routingTable());
    }

    private void applyAliases(ClusterChangedEvent event) {
        if (this.aliasesChanged(event)) {
            for (IndexMetaData indexMetaData : event.state().metaData()) {
                String index = indexMetaData.index();
                IndexService indexService = this.indicesService.indexService(index);
                if (indexService == null) continue;
                IndexAliasesService indexAliasesService = indexService.aliasesService();
                this.processAliases(index, indexMetaData.aliases().values(), indexAliasesService);
                for (IndexAlias indexAlias : indexAliasesService) {
                    if (indexMetaData.aliases().containsKey(indexAlias.alias())) continue;
                    indexAliasesService.remove(indexAlias.alias());
                }
            }
        }
    }

    private void processAliases(String index, ObjectContainer<AliasMetaData> aliases, IndexAliasesService indexAliasesService) {
        HashMap<String, IndexAlias> newAliases = Maps.newHashMap();
        for (ObjectCursor<AliasMetaData> objectCursor : aliases) {
            AliasMetaData aliasMd = (AliasMetaData)objectCursor.value;
            String alias = aliasMd.alias();
            CompressedString filter = aliasMd.filter();
            try {
                if (!indexAliasesService.hasAlias(alias)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] adding alias [{}], filter [{}]", index, alias, filter);
                    }
                    newAliases.put(alias, indexAliasesService.create(alias, filter));
                    continue;
                }
                if ((filter != null || indexAliasesService.alias(alias).filter() == null) && (filter == null || filter.equals(indexAliasesService.alias(alias).filter()))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}] updating alias [{}], filter [{}]", index, alias, filter);
                }
                newAliases.put(alias, indexAliasesService.create(alias, filter));
            }
            catch (Throwable e) {
                this.logger.warn("[{}] failed to add alias [{}], filter [{}]", e, index, alias, filter);
            }
        }
        indexAliasesService.addAll(newAliases);
    }

    private void applyNewOrUpdatedShards(ClusterChangedEvent event) throws ElasticsearchException {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            this.failedShards.clear();
            return;
        }
        DiscoveryNodes nodes = event.state().nodes();
        for (ShardRouting shardRouting : routingNode) {
            IndexMetaData indexMetaData;
            IndexService indexService = this.indicesService.indexService(shardRouting.index());
            if (indexService == null || (indexMetaData = event.state().metaData().index(shardRouting.index())) == null) continue;
            int shardId = shardRouting.id();
            if (!indexService.hasShard(shardId) && shardRouting.started()) {
                if (this.failedShards.containsKey(shardRouting.shardId())) {
                    if (nodes.masterNode() == null) continue;
                    this.shardStateAction.resendShardFailed(shardRouting, indexMetaData.getUUID(), "master " + nodes.masterNode() + " marked shard as started, but shard has previous failed. resending shard failure.", nodes.masterNode());
                    continue;
                }
                this.sendFailShard(shardRouting, indexMetaData.getUUID(), "master [" + nodes.masterNode() + "] marked shard as started, but shard has not been created, mark shard as failed", null);
                continue;
            }
            IndexShard indexShard = indexService.shard(shardId);
            if (indexShard != null) {
                ShardRouting currentRoutingEntry = indexShard.routingEntry();
                boolean shardHasBeenRemoved = false;
                if (currentRoutingEntry.initializing() && shardRouting.initializing() && !currentRoutingEntry.equals(shardRouting)) {
                    this.logger.debug("[{}][{}] removing shard (different instance of it allocated on this node, current [{}], global [{}])", shardRouting.index(), shardRouting.id(), currentRoutingEntry, shardRouting);
                    indexService.removeShard(shardRouting.id(), "removing shard (different instance of it allocated on this node)");
                    shardHasBeenRemoved = true;
                } else if (this.isPeerRecovery(shardRouting)) {
                    final DiscoveryNode sourceNode = this.findSourceNodeForPeerRecovery(routingTable, nodes, shardRouting);
                    Predicate<RecoveryStatus> shouldCancel = new Predicate<RecoveryStatus>(){

                        @Override
                        public boolean apply(@Nullable RecoveryStatus status) {
                            return !status.sourceNode().equals(sourceNode);
                        }
                    };
                    if (this.recoveryTarget.cancelRecoveriesForShard(indexShard.shardId(), "recovery source node changed", shouldCancel)) {
                        this.logger.debug("[{}][{}] removing shard (recovery source changed), current [{}], global [{}])", shardRouting.index(), shardRouting.id(), currentRoutingEntry, shardRouting);
                        indexService.removeShard(shardRouting.id(), "removing shard (recovery source node changed)");
                        shardHasBeenRemoved = true;
                    }
                }
                if (!shardHasBeenRemoved && !shardRouting.equals(indexShard.routingEntry())) {
                    if (shardRouting.primary() && !indexShard.routingEntry().primary() && shardRouting.initializing() && !indexShard.allowsPrimaryPromotion()) {
                        this.logger.debug("{} reinitialize shard on primary promotion", indexShard.shardId());
                        indexService.removeShard(shardId, "promoted to primary");
                    } else {
                        indexShard.routingEntry(shardRouting);
                        indexService.shardInjectorSafe(shardId).getInstance(IndexShardGatewayService.class).routingStateChanged();
                    }
                }
            }
            if (!shardRouting.initializing()) continue;
            this.applyInitializingShard(routingTable, nodes, indexMetaData, routingTable.index(shardRouting.index()).shard(shardRouting.id()), shardRouting);
        }
    }

    private void cleanFailedShards(ClusterChangedEvent event) {
        RoutingTable routingTable = event.state().routingTable();
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            this.failedShards.clear();
            return;
        }
        DiscoveryNodes nodes = event.state().nodes();
        long now = System.currentTimeMillis();
        String localNodeId = nodes.localNodeId();
        Iterator iterator = this.failedShards.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            IndexShardRoutingTable shardRoutingTable;
            Map.Entry entry = iterator.next();
            FailedShard failedShard = (FailedShard)entry.getValue();
            IndexRoutingTable indexRoutingTable = routingTable.index(((ShardId)entry.getKey()).getIndex());
            if (indexRoutingTable != null && (shardRoutingTable = indexRoutingTable.shard(((ShardId)entry.getKey()).id())) != null) {
                for (ShardRouting shardRouting : shardRoutingTable.assignedShards()) {
                    if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
                    if (shardRouting.version() == failedShard.version && now - failedShard.timestamp < TimeValue.timeValueMinutes(60L).millis()) continue block0;
                }
            }
            iterator.remove();
        }
    }

    private void applyInitializingShard(RoutingTable routingTable, DiscoveryNodes nodes, final IndexMetaData indexMetaData, IndexShardRoutingTable indexShardRouting, final ShardRouting shardRouting) throws ElasticsearchException {
        IndexShard indexShard;
        final IndexService indexService = this.indicesService.indexService(shardRouting.index());
        if (indexService == null) {
            return;
        }
        int shardId = shardRouting.id();
        if (indexService.hasShard(shardId)) {
            IndexShard indexShard2 = indexService.shardSafe(shardId);
            if (indexShard2.state() == IndexShardState.STARTED || indexShard2.state() == IndexShardState.POST_RECOVERY) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("{} master marked shard as initializing, but shard has state [{}], resending shard started to {}", new Object[]{indexShard2.shardId(), indexShard2.state(), nodes.masterNode()});
                }
                if (nodes.masterNode() != null) {
                    this.shardStateAction.shardStarted(shardRouting, indexMetaData.getUUID(), "master " + nodes.masterNode() + " marked shard as initializing, but shard state is [" + (Object)((Object)indexShard2.state()) + "], mark shard as started", nodes.masterNode());
                }
                return;
            }
            if (indexShard2.ignoreRecoveryAttempt()) {
                this.logger.trace("ignoring recovery instruction for an existing shard {} (shard state: [{}])", new Object[]{indexShard2.shardId(), indexShard2.state()});
                return;
            }
        }
        DiscoveryNode sourceNode = null;
        if (this.isPeerRecovery(shardRouting) && (sourceNode = this.findSourceNodeForPeerRecovery(routingTable, nodes, shardRouting)) == null) {
            this.logger.trace("ignoring initializing shard {} - no source node can be found.", shardRouting.shardId());
            return;
        }
        if (!indexService.hasShard(shardId)) {
            if (this.failedShards.containsKey(shardRouting.shardId())) {
                if (nodes.masterNode() != null) {
                    this.shardStateAction.resendShardFailed(shardRouting, indexMetaData.getUUID(), "master " + nodes.masterNode() + " marked shard as initializing, but shard is marked as failed, resend shard failure", nodes.masterNode());
                }
                return;
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] creating shard", shardRouting.index(), shardId);
                }
                indexShard = indexService.createShard(shardId, shardRouting.primary());
                indexShard.routingEntry(shardRouting);
                indexShard.addFailedEngineListener(this.failedEngineHandler);
            }
            catch (IndexShardAlreadyExistsException e) {
            }
            catch (Throwable e) {
                this.failAndRemoveShard(shardRouting, indexService, true, "failed to create shard", e);
                return;
            }
        }
        if ((indexShard = indexService.shardSafe(shardId)).ignoreRecoveryAttempt()) {
            this.logger.trace("ignoring recovery instruction for shard {} (shard state: [{}])", new Object[]{indexShard.shardId(), indexShard.state()});
            return;
        }
        if (this.isPeerRecovery(shardRouting)) {
            try {
                assert (sourceNode != null) : "peer recovery started but sourceNode is null";
                RecoveryState.Type type = shardRouting.primary() ? RecoveryState.Type.RELOCATION : RecoveryState.Type.REPLICA;
                this.recoveryTarget.startRecovery(indexShard, type, sourceNode, new PeerRecoveryListener(shardRouting, indexService, indexMetaData));
            }
            catch (Throwable e) {
                indexShard.failShard("corrupted preexisting index", e);
                this.handleRecoveryFailure(indexService, shardRouting, true, e);
            }
        } else {
            boolean indexShouldExists = indexShardRouting.primaryAllocatedPostApi();
            IndexShardGatewayService shardGatewayService = indexService.shardInjectorSafe(shardId).getInstance(IndexShardGatewayService.class);
            shardGatewayService.recover(indexShouldExists, new IndexShardGatewayService.RecoveryListener(){

                @Override
                public void onRecoveryDone() {
                    IndicesClusterStateService.this.shardStateAction.shardStarted(shardRouting, indexMetaData.getUUID(), "after recovery from gateway");
                }

                @Override
                public void onIgnoreRecovery(String reason) {
                }

                @Override
                public void onRecoveryFailed(IndexShardGatewayRecoveryException e) {
                    IndicesClusterStateService.this.handleRecoveryFailure(indexService, shardRouting, true, e);
                }
            });
        }
    }

    private DiscoveryNode findSourceNodeForPeerRecovery(RoutingTable routingTable, DiscoveryNodes nodes, ShardRouting shardRouting) {
        DiscoveryNode sourceNode = null;
        if (!shardRouting.primary()) {
            IndexShardRoutingTable shardRoutingTable = routingTable.index(shardRouting.index()).shard(shardRouting.id());
            for (ShardRouting entry : shardRoutingTable) {
                if (!entry.primary() || !entry.active()) continue;
                sourceNode = nodes.get(entry.currentNodeId());
                if (sourceNode != null) break;
                this.logger.trace("can't find replica source node because primary shard {} is assigned to an unknown node.", entry);
                return null;
            }
            if (sourceNode == null) {
                this.logger.trace("can't find replica source node for {} because a primary shard can not be found.", shardRouting.shardId());
            }
        } else if (shardRouting.relocatingNodeId() != null) {
            sourceNode = nodes.get(shardRouting.relocatingNodeId());
            if (sourceNode == null) {
                this.logger.trace("can't find relocation source node for shard {} because it is assigned to an unknown node [{}].", shardRouting.shardId(), shardRouting.relocatingNodeId());
            }
        } else {
            throw new ElasticsearchIllegalStateException("trying to find source node for peer recovery when routing state means no peer recovery: " + shardRouting);
        }
        return sourceNode;
    }

    private boolean isPeerRecovery(ShardRouting shardRouting) {
        return !shardRouting.primary() || shardRouting.relocatingNodeId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryFailure(IndexService indexService, ShardRouting shardRouting, boolean sendShardFailure, Throwable failure) {
        Object object = this.mutex;
        synchronized (object) {
            this.failAndRemoveShard(shardRouting, indexService, sendShardFailure, "failed recovery", failure);
        }
    }

    private void removeIndex(String index, String reason) {
        try {
            this.indicesService.removeIndex(index, reason);
        }
        catch (Throwable e) {
            this.logger.warn("failed to clean index ({})", e, reason);
        }
        this.clearSeenMappings(index);
    }

    private void clearSeenMappings(String index) {
        for (Tuple tuple : this.seenMappings.keySet()) {
            if (!((String)tuple.v1()).equals(index)) continue;
            this.seenMappings.remove(tuple);
        }
    }

    private void deleteIndex(String index, String reason) {
        try {
            this.indicesService.deleteIndex(index, reason);
        }
        catch (Throwable e) {
            this.logger.warn("failed to delete index ({})", e, reason);
        }
        this.clearSeenMappings(index);
    }

    private void failAndRemoveShard(ShardRouting shardRouting, IndexService indexService, boolean sendShardFailure, String message, @Nullable Throwable failure) {
        if (indexService.hasShard(shardRouting.getId())) {
            try {
                indexService.removeShard(shardRouting.getId(), message);
            }
            catch (IndexShardMissingException e) {
            }
            catch (Throwable e1) {
                this.logger.warn("[{}][{}] failed to remove shard after failure ([{}])", e1, shardRouting.getIndex(), shardRouting.getId(), message);
            }
        }
        if (sendShardFailure) {
            this.sendFailShard(shardRouting, indexService.indexUUID(), message, failure);
        }
    }

    private void sendFailShard(ShardRouting shardRouting, String indexUUID, String message, @Nullable Throwable failure) {
        try {
            this.logger.warn("[{}] marking and sending shard failed due to [{}]", failure, shardRouting.shardId(), message);
            this.failedShards.put(shardRouting.shardId(), new FailedShard(shardRouting.version()));
            this.shardStateAction.shardFailed(shardRouting, indexUUID, "shard failure [" + message + "]" + (failure == null ? "" : "[" + ExceptionsHelper.detailedMessage(failure) + "]"));
        }
        catch (Throwable e1) {
            this.logger.warn("[{}][{}] failed to mark shard as failed (because of [{}])", e1, shardRouting.getIndex(), shardRouting.getId(), message);
        }
    }

    private class FailedEngineHandler
    implements Engine.FailedEngineListener {
        private FailedEngineHandler() {
        }

        @Override
        public void onFailedEngine(ShardId shardId, final String reason, final @Nullable Throwable failure) {
            IndexShard indexShard;
            ShardRouting shardRouting = null;
            final IndexService indexService = IndicesClusterStateService.this.indicesService.indexService(shardId.index().name());
            if (indexService != null && (indexShard = indexService.shard(shardId.id())) != null) {
                shardRouting = indexShard.routingEntry();
            }
            if (shardRouting == null) {
                IndicesClusterStateService.this.logger.warn("[{}][{}] engine failed, but can't find index shard. failure reason: [{}]", failure, shardId.index().name(), shardId.id(), reason);
                return;
            }
            final ShardRouting fShardRouting = shardRouting;
            IndicesClusterStateService.this.threadPool.generic().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = IndicesClusterStateService.this.mutex;
                    synchronized (object) {
                        IndicesClusterStateService.this.failAndRemoveShard(fShardRouting, indexService, true, "engine failure, reason [" + reason + "]", failure);
                    }
                }
            });
        }
    }

    private class PeerRecoveryListener
    implements RecoveryTarget.RecoveryListener {
        private final ShardRouting shardRouting;
        private final IndexService indexService;
        private final IndexMetaData indexMetaData;

        private PeerRecoveryListener(ShardRouting shardRouting, IndexService indexService, IndexMetaData indexMetaData) {
            this.shardRouting = shardRouting;
            this.indexService = indexService;
            this.indexMetaData = indexMetaData;
        }

        @Override
        public void onRecoveryDone(RecoveryState state) {
            IndicesClusterStateService.this.shardStateAction.shardStarted(this.shardRouting, this.indexMetaData.getUUID(), "after recovery (replica) from node [" + state.getSourceNode() + "]");
        }

        @Override
        public void onRecoveryFailure(RecoveryState state, RecoveryFailedException e, boolean sendShardFailure) {
            IndicesClusterStateService.this.handleRecoveryFailure(this.indexService, this.shardRouting, sendShardFailure, e);
        }
    }

    static class FailedShard {
        public final long version;
        public final long timestamp;

        FailedShard(long version) {
            this.version = version;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

