/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;

public class FunctionScoreQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<FunctionScoreQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private final FilterBuilder filterBuilder;
    private Float boost;
    private Float maxBoost;
    private String scoreMode;
    private String boostMode;
    private ArrayList<FilterBuilder> filters = new ArrayList();
    private ArrayList<ScoreFunctionBuilder> scoreFunctions = new ArrayList();
    private Float minScore = null;

    public FunctionScoreQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.filterBuilder = null;
    }

    public FunctionScoreQueryBuilder(FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        this.queryBuilder = null;
    }

    public FunctionScoreQueryBuilder(QueryBuilder queryBuilder, FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        this.queryBuilder = queryBuilder;
    }

    public FunctionScoreQueryBuilder() {
        this.filterBuilder = null;
        this.queryBuilder = null;
    }

    public FunctionScoreQueryBuilder(ScoreFunctionBuilder scoreFunctionBuilder) {
        if (scoreFunctionBuilder == null) {
            throw new ElasticsearchIllegalArgumentException("function_score: function must not be null");
        }
        this.queryBuilder = null;
        this.filterBuilder = null;
        this.filters.add(null);
        this.scoreFunctions.add(scoreFunctionBuilder);
    }

    public FunctionScoreQueryBuilder add(FilterBuilder filter, ScoreFunctionBuilder scoreFunctionBuilder) {
        if (scoreFunctionBuilder == null) {
            throw new ElasticsearchIllegalArgumentException("function_score: function must not be null");
        }
        this.filters.add(filter);
        this.scoreFunctions.add(scoreFunctionBuilder);
        return this;
    }

    public FunctionScoreQueryBuilder add(ScoreFunctionBuilder scoreFunctionBuilder) {
        if (scoreFunctionBuilder == null) {
            throw new ElasticsearchIllegalArgumentException("function_score: function must not be null");
        }
        this.filters.add(null);
        this.scoreFunctions.add(scoreFunctionBuilder);
        return this;
    }

    public FunctionScoreQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    public FunctionScoreQueryBuilder boostMode(String boostMode) {
        this.boostMode = boostMode;
        return this;
    }

    public FunctionScoreQueryBuilder boostMode(CombineFunction combineFunction) {
        this.boostMode = combineFunction.getName();
        return this;
    }

    public FunctionScoreQueryBuilder maxBoost(float maxBoost) {
        this.maxBoost = Float.valueOf(maxBoost);
        return this;
    }

    @Override
    public FunctionScoreQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("function_score");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        builder.startArray("functions");
        for (int i = 0; i < this.filters.size(); ++i) {
            builder.startObject();
            if (this.filters.get(i) != null) {
                builder.field("filter");
                this.filters.get(i).toXContent(builder, params);
            }
            this.scoreFunctions.get(i).toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.boostMode != null) {
            builder.field("boost_mode", this.boostMode);
        }
        if (this.maxBoost != null) {
            builder.field("max_boost", this.maxBoost);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.minScore != null) {
            builder.field("min_score", this.minScore);
        }
        builder.endObject();
    }

    public FunctionScoreQueryBuilder setMinScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }
}

