/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;

public class TemplateQueryParser
implements QueryParser {
    public static final String NAME = "template";
    public static final String QUERY = "query";
    public static final String PARAMS = "params";
    private final ScriptService scriptService;
    private static final Map<String, ScriptService.ScriptType> parametersToTypes = new HashMap<String, ScriptService.ScriptType>();

    @Inject
    public TemplateQueryParser(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    @Nullable
    public Query parse(QueryParseContext parseContext) throws IOException {
        XContentParser parser = parseContext.parser();
        TemplateContext templateContext = TemplateQueryParser.parse(parser, PARAMS, parametersToTypes);
        ExecutableScript executable = this.scriptService.executable("mustache", templateContext.template(), templateContext.scriptType(), ScriptContext.Standard.SEARCH, templateContext.params());
        BytesReference querySource = (BytesReference)executable.run();
        try (XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);){
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParserService());
            context.reset(qSourceParser);
            Query query = context.parseInnerQuery();
            return query;
        }
    }

    public static TemplateContext parse(XContentParser parser, String paramsFieldname, String ... parameters) throws IOException {
        HashMap<String, ScriptService.ScriptType> parameterMap = new HashMap<String, ScriptService.ScriptType>(parametersToTypes);
        for (String parameter : parameters) {
            parameterMap.put(parameter, ScriptService.ScriptType.INLINE);
        }
        return TemplateQueryParser.parse(parser, paramsFieldname, parameterMap);
    }

    public static TemplateContext parse(XContentParser parser, String paramsFieldname) throws IOException {
        return TemplateQueryParser.parse(parser, paramsFieldname, parametersToTypes);
    }

    public static TemplateContext parse(XContentParser parser, String paramsFieldname, Map<String, ScriptService.ScriptType> parameterMap) throws IOException {
        XContentParser.Token token;
        Map<String, Object> params = null;
        String templateNameOrTemplateContent = null;
        String currentFieldName = null;
        ScriptService.ScriptType type = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parameterMap.containsKey(currentFieldName)) {
                type = parameterMap.get(currentFieldName);
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
                    builder.copyCurrentStructure(parser);
                    templateNameOrTemplateContent = builder.string();
                    continue;
                }
                templateNameOrTemplateContent = parser.text();
                continue;
            }
            if (!paramsFieldname.equals(currentFieldName)) continue;
            params = parser.map();
        }
        return new TemplateContext(type, templateNameOrTemplateContent, params);
    }

    static {
        parametersToTypes.put(QUERY, ScriptService.ScriptType.INLINE);
        parametersToTypes.put("file", ScriptService.ScriptType.FILE);
        parametersToTypes.put("id", ScriptService.ScriptType.INDEXED);
    }

    public static class TemplateContext {
        private Map<String, Object> params;
        private String template;
        private ScriptService.ScriptType type;

        public TemplateContext(ScriptService.ScriptType type, String template, Map<String, Object> params) {
            this.params = params;
            this.template = template;
            this.type = type;
        }

        public Map<String, Object> params() {
            return this.params;
        }

        public String template() {
            return this.template;
        }

        public ScriptService.ScriptType scriptType() {
            return this.type;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.template;
        }
    }
}

