/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.termvector.MultiTermVectorsRequest;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.morelikethis.MoreLikeThisFetchService;
import org.elasticsearch.search.internal.SearchContext;

public class MoreLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "mlt";
    private MoreLikeThisFetchService fetchService = null;

    @Inject(optional=true)
    public void setFetchService(@Nullable MoreLikeThisFetchService fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this", "moreLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        boolean useDefaultField;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        Object analyzer = null;
        AbstractList moreLikeFields = null;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        boolean include = false;
        String currentFieldName = null;
        MultiTermVectorsRequest items = new MultiTermVectorsRequest();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (Fields.LIKE_TEXT.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if (Fields.MIN_TERM_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if (Fields.MAX_QUERY_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if (Fields.MIN_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if (Fields.MAX_DOC_FREQ.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if (Fields.MIN_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if (Fields.MAX_WORD_LENGTH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if (Fields.BOOST_TERMS.match(currentFieldName, parseContext.parseFlags())) {
                    float boostFactor = parser.floatValue();
                    if (boostFactor == 0.0f) continue;
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(boostFactor);
                    continue;
                }
                if (Fields.MINIMUM_SHOULD_MATCH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinimumShouldMatch(parser.text());
                    continue;
                }
                if (Fields.PERCENT_TERMS_TO_MATCH.match(currentFieldName, parseContext.parseFlags())) {
                    mltQuery.setMinimumShouldMatch(Math.round(parser.floatValue() * 100.0f) + "%");
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                if (Fields.FAIL_ON_UNSUPPORTED_FIELD.match(currentFieldName, parseContext.parseFlags())) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if (Fields.INCLUDE.match(currentFieldName, parseContext.parseFlags())) {
                    include = parser.booleanValue();
                    continue;
                }
                if (Fields.EXCLUDE.match(currentFieldName, parseContext.parseFlags())) {
                    include = !parser.booleanValue();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (Fields.STOP_WORDS.match(currentFieldName, parseContext.parseFlags())) {
                HashSet<String> stopWords = Sets.newHashSet();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    stopWords.add(parser.text());
                }
                mltQuery.setStopWords(stopWords);
                continue;
            }
            if ("fields".equals(currentFieldName)) {
                moreLikeFields = Lists.newLinkedList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    moreLikeFields.add(parseContext.indexName(parser.text()));
                }
                continue;
            }
            if (Fields.DOCUMENT_IDS.match(currentFieldName, parseContext.parseFlags())) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new ElasticsearchIllegalArgumentException("ids array element should only contain ids");
                    }
                    items.add(this.newTermVectorRequest().id(parser.text()));
                }
                continue;
            }
            if (Fields.DOCUMENTS.match(currentFieldName, parseContext.parseFlags())) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchIllegalArgumentException("docs array element should include an object");
                    }
                    items.add(this.parseDocuments(parser));
                }
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
        }
        if (mltQuery.getLikeText() == null && items.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires at least 'like_text' or 'ids/docs' to be specified");
        }
        if (moreLikeFields != null && moreLikeFields.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'fields' to be non-empty");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer((Analyzer)analyzer);
        boolean bl = useDefaultField = moreLikeFields == null;
        if (useDefaultField) {
            moreLikeFields = Lists.newArrayList(parseContext.defaultField());
        }
        this.removeUnsupportedFields(moreLikeFields, (Analyzer)analyzer, failOnUnsupportedField);
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(Strings.EMPTY_ARRAY));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, mltQuery);
        }
        if (!items.isEmpty()) {
            for (TermVectorRequest item : items) {
                if (item.index() == null) {
                    item.index(parseContext.index().name());
                }
                if (item.type() == null) {
                    if (parseContext.queryTypes().size() > 1) {
                        throw new QueryParsingException(parseContext.index(), "ambiguous type for item with id: " + item.id() + " and index: " + item.index());
                    }
                    item.type(parseContext.queryTypes().iterator().next());
                }
                if (item.selectedFields() != null || item.doc() != null) continue;
                if (useDefaultField) {
                    item.selectedFields("*");
                    continue;
                }
                item.selectedFields(moreLikeFields.toArray(new String[moreLikeFields.size()]));
            }
            items.copyContextAndHeadersFrom(SearchContext.current());
            org.apache.lucene.index.Fields[] likeFields = this.fetchService.fetch(items);
            mltQuery.setLikeText(likeFields);
            BooleanQuery boolQuery = new BooleanQuery();
            boolQuery.add((Query)mltQuery, BooleanClause.Occur.SHOULD);
            if (!include) {
                this.handleExclude(boolQuery, items);
            }
            return boolQuery;
        }
        return mltQuery;
    }

    private TermVectorRequest newTermVectorRequest() {
        return new TermVectorRequest().positions(false).offsets(false).payloads(false).fieldStatistics(false).termStatistics(false);
    }

    private TermVectorRequest parseDocuments(XContentParser parser) throws IOException {
        TermVectorRequest termVectorRequest = this.newTermVectorRequest();
        TermVectorRequest.parseRequest(termVectorRequest, parser);
        return termVectorRequest;
    }

    private List<String> removeUnsupportedFields(List<String> moreLikeFields, Analyzer analyzer, boolean failOnUnsupportedField) throws IOException {
        Iterator<String> it = moreLikeFields.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            if (Analysis.generatesCharacterTokenStream(analyzer, fieldName)) continue;
            if (failOnUnsupportedField) {
                throw new ElasticsearchIllegalArgumentException("more_like_this doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            it.remove();
        }
        return moreLikeFields;
    }

    private void handleExclude(BooleanQuery boolQuery, MultiTermVectorsRequest likeItems) {
        ArrayList<BytesRef> uids = new ArrayList<BytesRef>();
        for (TermVectorRequest item : likeItems) {
            if (item.doc() != null) continue;
            uids.add(Uid.createUidAsBytes(item.type(), item.id()));
        }
        if (!uids.isEmpty()) {
            TermsFilter filter = new TermsFilter("_uid", uids.toArray(new BytesRef[0]));
            ConstantScoreQuery query = new ConstantScoreQuery((Filter)filter);
            boolQuery.add((Query)query, BooleanClause.Occur.MUST_NOT);
        }
    }

    public static class Fields {
        public static final ParseField LIKE_TEXT = new ParseField("like_text", new String[0]);
        public static final ParseField MIN_TERM_FREQ = new ParseField("min_term_freq", new String[0]);
        public static final ParseField MAX_QUERY_TERMS = new ParseField("max_query_terms", new String[0]);
        public static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", "min_word_len");
        public static final ParseField MAX_WORD_LENGTH = new ParseField("max_word_length", "max_word_len");
        public static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
        public static final ParseField MAX_DOC_FREQ = new ParseField("max_doc_freq", new String[0]);
        public static final ParseField BOOST_TERMS = new ParseField("boost_terms", new String[0]);
        public static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
        public static final ParseField PERCENT_TERMS_TO_MATCH = new ParseField("percent_terms_to_match", new String[0]).withAllDeprecated("minimum_should_match");
        public static final ParseField FAIL_ON_UNSUPPORTED_FIELD = new ParseField("fail_on_unsupported_field", new String[0]);
        public static final ParseField STOP_WORDS = new ParseField("stop_words", new String[0]);
        public static final ParseField DOCUMENT_IDS = new ParseField("ids", new String[0]);
        public static final ParseField DOCUMENTS = new ParseField("docs", new String[0]);
        public static final ParseField INCLUDE = new ParseField("include", new String[0]);
        public static final ParseField EXCLUDE = new ParseField("exclude", new String[0]);
    }
}

