/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.local.state.meta.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.local.state.meta.MetaDataStateFormat;
import org.elasticsearch.gateway.local.state.meta.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalGatewayMetaState
extends AbstractComponent
implements ClusterStateListener {
    static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final String INDEX_STATE_FILE_PREFIX = "state-";
    private static final String GLOBAL_STATE_LOG_TYPE = "[_global]";
    private final NodeEnvironment nodeEnv;
    private final ThreadPool threadPool;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    @Nullable
    private volatile MetaData currentMetaData;
    private final XContentType format;
    private final ToXContent.Params formatParams;
    private final ToXContent.Params gatewayModeFormatParams;
    private final AutoImportDangledState autoImportDangled;
    private final TimeValue danglingTimeout;
    private final TimeValue deleteTimeout;
    private final Map<String, DanglingIndex> danglingIndices = ConcurrentCollections.newConcurrentMap();
    private final Object danglingMutex = new Object();
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final MetaDataStateFormat<IndexMetaData> indexStateFormat;
    private final MetaDataStateFormat<MetaData> globalStateFormat;

    @Inject
    public LocalGatewayMetaState(Settings settings, ThreadPool threadPool, NodeEnvironment nodeEnv, TransportNodesListGatewayMetaState nodesListGatewayMetaState, LocalAllocateDangledIndices allocateDangledIndices, IndicesService indicesService, ClusterService clusterService) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.threadPool = threadPool;
        this.format = XContentType.fromRestContentType(settings.get("format", "smile"));
        this.allocateDangledIndices = allocateDangledIndices;
        nodesListGatewayMetaState.init(this);
        if (this.format == XContentType.SMILE) {
            HashMap<String, String> params = Maps.newHashMap();
            params.put("binary", "true");
            this.formatParams = new ToXContent.MapParams(params);
            HashMap<String, String> gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("binary", "true");
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        } else {
            this.formatParams = ToXContent.EMPTY_PARAMS;
            HashMap<String, String> gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        }
        this.autoImportDangled = AutoImportDangledState.fromString(settings.get("gateway.local.auto_import_dangled", AutoImportDangledState.YES.toString()));
        this.danglingTimeout = settings.getAsTime("gateway.local.dangling_timeout", TimeValue.timeValueHours(2L));
        this.deleteTimeout = settings.getAsTime("gateway.local.delete_timeout", TimeValue.timeValueSeconds(30L));
        this.logger.debug("using gateway.local.auto_import_dangled [{}], gateway.local.delete_timeout [{}], with gateway.local.dangling_timeout [{}]", new Object[]{this.autoImportDangled, this.deleteTimeout, this.danglingTimeout});
        this.indexStateFormat = LocalGatewayMetaState.indexStateFormat(this.format, this.formatParams);
        this.globalStateFormat = LocalGatewayMetaState.globalStateFormat(this.format, this.gatewayModeFormatParams);
        if (DiscoveryNode.masterNode(settings) || DiscoveryNode.dataNode(settings)) {
            nodeEnv.ensureAtomicMoveSupported();
        }
        if (DiscoveryNode.masterNode(settings)) {
            try {
                this.pre019Upgrade();
                long start = System.currentTimeMillis();
                this.loadState();
                this.logger.debug("took {} to load state", TimeValue.timeValueMillis(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state, exiting...", e, new Object[0]);
                throw e;
            }
        }
        this.indicesService = indicesService;
        this.clusterService = clusterService;
    }

    public MetaData loadMetaState() throws Exception {
        return this.loadState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            this.currentMetaData = null;
            return;
        }
        MetaData newMetaData = state.metaData();
        boolean success = true;
        if (state.nodes().localNode().masterNode()) {
            if (this.currentMetaData == null || !MetaData.isGlobalStateEquals(this.currentMetaData, newMetaData)) {
                try {
                    this.writeGlobalState("changed", newMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
            for (IndexMetaData indexMetaData : newMetaData) {
                String writeReason = null;
                IndexMetaData currentIndexMetaData = this.currentMetaData == null ? this.loadIndexState(indexMetaData.index()) : this.currentMetaData.index(indexMetaData.index());
                if (currentIndexMetaData == null) {
                    writeReason = "freshly created";
                } else if (currentIndexMetaData.version() != indexMetaData.version()) {
                    writeReason = "version changed from [" + currentIndexMetaData.version() + "] to [" + indexMetaData.version() + "]";
                }
                if (writeReason == null) continue;
                try {
                    this.writeIndex(writeReason, indexMetaData, currentIndexMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
        }
        if (this.nodeEnv.hasNodeFile()) {
            IndexMetaData indexMetaData;
            if (this.danglingTimeout.millis() >= 0L) {
                Object i$ = this.danglingMutex;
                synchronized (i$) {
                    for (String danglingIndex : this.danglingIndices.keySet()) {
                        if (!newMetaData.hasIndex(danglingIndex)) continue;
                        this.logger.debug("[{}] no longer dangling (created), removing", danglingIndex);
                        DanglingIndex removed = this.danglingIndices.remove(danglingIndex);
                        FutureUtils.cancel(removed.future);
                    }
                    try {
                        for (String indexName : this.nodeEnv.findAllIndices()) {
                            if (newMetaData.hasIndex(indexName) || this.danglingIndices.containsKey(indexName) || (indexMetaData = this.loadIndexState(indexName)) == null) continue;
                            if (this.autoImportDangled.shouldImport()) {
                                this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, auto import to cluster state [{}]", new Object[]{indexName, this.autoImportDangled});
                                this.danglingIndices.put(indexName, new DanglingIndex(indexName, null));
                                continue;
                            }
                            if (this.danglingTimeout.millis() == 0L) {
                                this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, timeout set to 0, deleting now", indexName);
                                this.indicesService.deleteIndexStore("dangling index with timeout set to 0", indexMetaData, state);
                                continue;
                            }
                            this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, scheduling to delete in [{}], auto import to cluster state [{}]", new Object[]{indexName, this.danglingTimeout, this.autoImportDangled});
                            this.danglingIndices.put(indexName, new DanglingIndex(indexName, this.threadPool.schedule(this.danglingTimeout, "same", new RemoveDanglingIndex(indexMetaData))));
                        }
                    }
                    catch (Throwable e) {
                        this.logger.warn("failed to find dangling indices", e, new Object[0]);
                    }
                }
            }
            if (this.autoImportDangled.shouldImport() && !this.danglingIndices.isEmpty()) {
                ArrayList<IndexMetaData> dangled = Lists.newArrayList();
                for (String indexName : this.danglingIndices.keySet()) {
                    indexMetaData = this.loadIndexState(indexName);
                    if (indexMetaData == null) {
                        this.logger.debug("failed to find state for dangling index [{}]", indexName);
                        continue;
                    }
                    if (!indexMetaData.index().equals(indexName)) {
                        this.logger.info("dangled index directory name is [{}], state name is [{}], renaming to directory name", indexName, indexMetaData.index());
                        indexMetaData = IndexMetaData.builder(indexMetaData).index(indexName).build();
                    }
                    if (this.autoImportDangled == AutoImportDangledState.CLOSED) {
                        indexMetaData = IndexMetaData.builder(indexMetaData).state(IndexMetaData.State.CLOSE).build();
                    }
                    if (indexMetaData == null) continue;
                    dangled.add(indexMetaData);
                }
                IndexMetaData[] dangledIndices = dangled.toArray(new IndexMetaData[dangled.size()]);
                try {
                    this.allocateDangledIndices.allocateDangled(dangledIndices, new LocalAllocateDangledIndices.Listener(){

                        @Override
                        public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                            LocalGatewayMetaState.this.logger.trace("allocated dangled", new Object[0]);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            LocalGatewayMetaState.this.logger.info("failed to send allocated dangled", e, new Object[0]);
                        }
                    });
                }
                catch (Throwable e) {
                    this.logger.warn("failed to send allocate dangled", e, new Object[0]);
                }
            }
        }
        if (success) {
            this.currentMetaData = newMetaData;
        }
    }

    static MetaDataStateFormat<MetaData> globalStateFormat(XContentType format, final ToXContent.Params formatParams) {
        return new MetaDataStateFormat<MetaData>(format, GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, MetaData state) throws IOException {
                MetaData.Builder.toXContent(state, builder, formatParams);
            }

            @Override
            public MetaData fromXContent(XContentParser parser) throws IOException {
                return MetaData.Builder.fromXContent(parser);
            }
        };
    }

    static MetaDataStateFormat<IndexMetaData> indexStateFormat(XContentType format, final ToXContent.Params formatParams) {
        return new MetaDataStateFormat<IndexMetaData>(format, INDEX_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, IndexMetaData state) throws IOException {
                IndexMetaData.Builder.toXContent(state, builder, formatParams);
            }

            @Override
            public IndexMetaData fromXContent(XContentParser parser) throws IOException {
                return IndexMetaData.Builder.fromXContent(parser);
            }
        };
    }

    private void writeIndex(String reason, IndexMetaData indexMetaData, @Nullable IndexMetaData previousIndexMetaData) throws Exception {
        this.logger.trace("[{}] writing state, reason [{}]", indexMetaData.index(), reason);
        try {
            this.indexStateFormat.write(indexMetaData, indexMetaData.version(), this.nodeEnv.indexLocations(new Index(indexMetaData.index())));
        }
        catch (Throwable ex) {
            this.logger.warn("[{}]: failed to write index state", ex, indexMetaData.index());
            throw new IOException("failed to write state for [" + indexMetaData.index() + "]", ex);
        }
    }

    private void writeGlobalState(String reason, MetaData metaData) throws Exception {
        this.logger.trace("{} writing state, reason [{}]", GLOBAL_STATE_LOG_TYPE, reason);
        try {
            this.globalStateFormat.write(metaData, metaData.version(), this.nodeEnv.nodeDataLocations());
        }
        catch (Throwable ex) {
            this.logger.warn("{}: failed to write global state", ex, GLOBAL_STATE_LOG_TYPE);
            throw new IOException("failed to write global state", ex);
        }
    }

    private MetaData loadState() throws Exception {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        Set<String> indices = this.nodeEnv.findAllIndices();
        for (String index : indices) {
            IndexMetaData indexMetaData = this.loadIndexState(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] failed to find metadata for existing index location", index);
                continue;
            }
            metaDataBuilder.put(indexMetaData, false);
        }
        return metaDataBuilder.build();
    }

    @Nullable
    private IndexMetaData loadIndexState(String index) {
        return this.indexStateFormat.loadLatestState(this.logger, this.nodeEnv.indexLocations(new Index(index)));
    }

    private MetaData loadGlobalState() {
        return this.globalStateFormat.loadLatestState(this.logger, this.nodeEnv.nodeDataLocations());
    }

    private void pre019Upgrade() throws Exception {
        long index = -1L;
        File metaDataFile = null;
        MetaData metaData = null;
        long version = -1L;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File stateLocation = new File(dataLocation, "_state");
            File[] stateFiles = stateLocation.listFiles();
            if (stateFiles == null) continue;
            for (File stateFile : stateFiles) {
                long fileIndex;
                String name;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[upgrade]: processing [" + stateFile.getName() + "]", new Object[0]);
                }
                if (!(name = stateFile.getName()).startsWith("metadata-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
                try {
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) continue;
                    try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
                        String currentFieldName = null;
                        XContentParser.Token token = parser.nextToken();
                        if (token != null) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    continue;
                                }
                                if (token == XContentParser.Token.START_OBJECT) {
                                    if (!"meta-data".equals(currentFieldName)) continue;
                                    metaData = MetaData.Builder.fromXContent(parser);
                                    continue;
                                }
                                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                                version = parser.longValue();
                            }
                        }
                    }
                    index = fileIndex;
                    metaDataFile = stateFile;
                }
                catch (IOException e) {
                    this.logger.warn("failed to read pre 0.19 state from [" + name + "], ignoring...", e, new Object[0]);
                }
            }
        }
        if (metaData == null) {
            return;
        }
        this.logger.info("found old metadata state, loading metadata from [{}] and converting to new metadata location and structure...", metaDataFile.getAbsolutePath());
        this.writeGlobalState("upgrade", MetaData.builder(metaData).version(version).build());
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData).version(version);
            indexMetaDataBuilder.settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put("index.version.created", Version.V_0_18_0));
            this.writeIndex("upgrade", indexMetaDataBuilder.build(), null);
        }
        File backupFile = new File(metaDataFile.getParentFile(), "backup-" + metaDataFile.getName());
        if (!metaDataFile.renameTo(backupFile)) {
            throw new IOException("failed to rename old state to backup state [" + metaDataFile.getAbsolutePath() + "]");
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File stateLocation = new File(dataLocation, "_state");
            File[] stateFiles = stateLocation.listFiles();
            if (stateFiles == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("metadata-")) continue;
                stateFile.delete();
            }
        }
        this.logger.info("conversion to new metadata location and format done, backup create at [{}]", backupFile.getAbsolutePath());
    }

    static class DanglingIndex {
        public final String index;
        public final ScheduledFuture future;

        DanglingIndex(String index, ScheduledFuture future) {
            this.index = index;
            this.future = future;
        }
    }

    class RemoveDanglingIndex
    implements Runnable {
        private final IndexMetaData metaData;

        RemoveDanglingIndex(IndexMetaData metaData) {
            this.metaData = metaData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LocalGatewayMetaState.this.danglingMutex;
            synchronized (object) {
                DanglingIndex remove = (DanglingIndex)LocalGatewayMetaState.this.danglingIndices.remove(this.metaData.index());
                if (remove == null) {
                    return;
                }
                LocalGatewayMetaState.this.logger.warn("[{}] deleting dangling index", this.metaData.index());
                try {
                    LocalGatewayMetaState.this.indicesService.deleteIndexStore("deleting dangling index", this.metaData, LocalGatewayMetaState.this.clusterService.state());
                }
                catch (Exception ex) {
                    LocalGatewayMetaState.this.logger.debug("failed to delete dangling index", ex, new Object[0]);
                }
            }
        }
    }

    static enum AutoImportDangledState {
        NO{

            @Override
            public boolean shouldImport() {
                return false;
            }
        }
        ,
        YES{

            @Override
            public boolean shouldImport() {
                return true;
            }
        }
        ,
        CLOSED{

            @Override
            public boolean shouldImport() {
                return true;
            }
        };


        public abstract boolean shouldImport();

        public static AutoImportDangledState fromString(String value) {
            if ("no".equalsIgnoreCase(value)) {
                return NO;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return YES;
            }
            if ("closed".equalsIgnoreCase(value)) {
                return CLOSED;
            }
            throw new ElasticsearchIllegalArgumentException("failed to parse [" + value + "], not a valid auto dangling import type");
        }
    }
}

