/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.io.stream.AdapterStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;

public class HandlesStreamOutput
extends AdapterStreamOutput {
    private final ObjectIntOpenHashMap<String> handles = new ObjectIntOpenHashMap();
    private final ObjectIntOpenHashMap<Text> handlesText = new ObjectIntOpenHashMap();

    public HandlesStreamOutput(StreamOutput out) {
        super(out);
    }

    @Override
    public void writeSharedString(String str) throws IOException {
        if (this.handles.containsKey(str)) {
            this.out.writeByte((byte)1);
            this.out.writeVInt(this.handles.lget());
        } else {
            int handle = this.handles.size();
            this.handles.put(str, handle);
            this.out.writeByte((byte)0);
            this.out.writeVInt(handle);
            this.out.writeString(str);
        }
    }

    @Override
    public void writeString(String s) throws IOException {
        this.out.writeString(s);
    }

    @Override
    public void writeSharedText(Text text) throws IOException {
        if (this.handlesText.containsKey(text)) {
            this.out.writeByte((byte)1);
            this.out.writeVInt(this.handlesText.lget());
        } else {
            int handle = this.handlesText.size();
            this.handlesText.put(text, handle);
            this.out.writeByte((byte)0);
            this.out.writeVInt(handle);
            this.out.writeText(text);
        }
    }

    @Override
    public void reset() throws IOException {
        this.clear();
        if (this.out != null) {
            this.out.reset();
        }
    }

    public void clear() {
        this.handles.clear();
        this.handlesText.clear();
    }
}

