/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.delete;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DelegatingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexedScriptAction
extends HandledTransportAction<DeleteIndexedScriptRequest, DeleteIndexedScriptResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportDeleteIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, "indices:data/write/script/delete", threadPool, transportService, actionFilters);
        this.scriptService = scriptService;
    }

    @Override
    public DeleteIndexedScriptRequest newRequestInstance() {
        return new DeleteIndexedScriptRequest();
    }

    @Override
    protected void doExecute(DeleteIndexedScriptRequest request, ActionListener<DeleteIndexedScriptResponse> listener) {
        this.scriptService.deleteScriptFromIndex(request, (ActionListener<DeleteResponse>)new DelegatingActionListener<DeleteResponse, DeleteIndexedScriptResponse>(listener){

            @Override
            public DeleteIndexedScriptResponse getDelegatedFromInstigator(DeleteResponse deleteResponse) {
                return new DeleteIndexedScriptResponse(deleteResponse.getIndex(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getVersion(), deleteResponse.isFound());
            }
        });
    }
}

