/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FieldStatsResponse
extends BroadcastOperationResponse {
    private Map<String, Map<String, FieldStats>> indicesMergedFieldStats;

    public FieldStatsResponse() {
    }

    public FieldStatsResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, Map<String, Map<String, FieldStats>> indicesMergedFieldStats) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.indicesMergedFieldStats = indicesMergedFieldStats;
    }

    @Nullable
    public Map<String, FieldStats> getAllFieldStats() {
        return this.indicesMergedFieldStats.get("_all");
    }

    public Map<String, Map<String, FieldStats>> getIndicesMergedFieldStats() {
        return this.indicesMergedFieldStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.indicesMergedFieldStats = new HashMap<String, Map<String, FieldStats>>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int indexSize = in.readVInt();
            HashMap<String, FieldStats> indexFieldStats = new HashMap<String, FieldStats>(indexSize);
            this.indicesMergedFieldStats.put(key, indexFieldStats);
            for (int j = 0; j < indexSize; ++j) {
                key = in.readString();
                FieldStats value = FieldStats.read(in);
                indexFieldStats.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indicesMergedFieldStats.size());
        for (Map.Entry<String, Map<String, FieldStats>> entry1 : this.indicesMergedFieldStats.entrySet()) {
            out.writeString(entry1.getKey());
            out.writeVInt(entry1.getValue().size());
            for (Map.Entry<String, FieldStats> entry2 : entry1.getValue().entrySet()) {
                out.writeString(entry2.getKey());
                entry2.getValue().writeTo(out);
            }
        }
    }
}

