/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.log;

import ch.qos.logback.classic.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackHelper {
    private static final Logger logger = LoggerFactory.getLogger(LogbackHelper.class);

    private LogbackHelper() {
    }

    public static void disableConsoleLoggerIfNeeded(String consoleAppenderName) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = lc.getLogger("ROOT");
        if (LogbackHelper.isServiceMode()) {
            if (root.getAppender(consoleAppenderName) != null) {
                root.info("Removing console log appender from root logger. Please search for other log entries in the application log file");
                root.detachAppender(consoleAppenderName);
            } else {
                logger.warn("{} appender not found. Cannot disable it to avoid console log pollution", (Object)consoleAppenderName);
            }
        }
    }

    private static boolean isServiceMode() {
        return System.console() == null;
    }
}

