/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameXLTESTTypeReferencesToXLTUpgrade
extends Upgrade {
    public Logger LOG = LoggerFactory.getLogger(RenameXLTESTTypeReferencesToXLTUpgrade.class);

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#2");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.renameQualificationTypeInSpecifications(repository);
        this.renameReportTypeInDashboardTiles(repository);
        return true;
    }

    private void renameReportTypeInDashboardTiles(RawRepository repository) {
        List dashboardTiles = repository.findNodesByType(Type.valueOf((String)"xlt.DashboardTile"));
        for (Node dashboardTile : dashboardTiles) {
            this.LOG.info("Renaming qualification type for dashboardTile {} ", (Object)dashboardTile);
            try {
                Property reportTypeProperty = dashboardTile.getProperty("reportType");
                String reportType = reportTypeProperty.getString();
                String renamedReportType = reportType.replace("xltest.", "xlt.");
                this.LOG.info("Renaming qualification type from {} to {} ", (Object)reportType, (Object)renamedReportType);
                reportTypeProperty.setValue(reportType.replace("xltest.", "xlt."));
            }
            catch (RepositoryException e) {
                throw new UpgradeException("Could not rename reportType for dashboardTile" + dashboardTile, (Exception)((Object)e));
            }
        }
    }

    private void renameQualificationTypeInSpecifications(RawRepository repository) {
        List<String> specificationTypes = Arrays.asList("xlt.ActiveTestSpecification", "xlt.PassiveTestSpecification", "xlt.ExecutableTestSpecification", "xlt.ShowCaseTestSpecification");
        for (String specificationType : specificationTypes) {
            List testSpecifications = repository.findNodesByType(Type.valueOf((String)specificationType));
            this.LOG.info("Renaming qualification type for specification {} ", (Object)specificationType);
            for (Node testSpecification : testSpecifications) {
                try {
                    if (!testSpecification.hasProperty("qualificationType")) continue;
                    Property qualificationProperty = testSpecification.getProperty("qualificationType");
                    String qualificationType = qualificationProperty.getString();
                    String renamedQualificationType = qualificationType.replace("xltest.", "xlt.");
                    this.LOG.info("Renaming qualification type from {} to {} ", (Object)qualificationType, (Object)renamedQualificationType);
                    qualificationProperty.setValue(renamedQualificationType);
                }
                catch (RepositoryException e) {
                    throw new UpgradeException("Could not rename qualification for testSpecification " + testSpecification, (Exception)((Object)e));
                }
            }
        }
    }
}

