/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MoveQualificationsToJcrUpgrade
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(MoveQualificationsToJcrUpgrade.class);
    private static final String QUALIFICATION = "qualification";
    private static final String QUALIFICATION_FAILURE_REASON = "failureReason";
    public static final String QUALIFICATION_COMPUTED = "qualificationComputed";
    private final EventRepository eventRepository;
    private final TestSpecificationRepository testSpecificationRepository;

    @Autowired
    public MoveQualificationsToJcrUpgrade(EventRepository eventRepository, TestSpecificationRepository testSpecificationRepository) {
        this.eventRepository = eventRepository;
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#4");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        FilteredQueryBuilder queryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.termFilter((String)"@type", (String)QUALIFICATION_COMPUTED));
        List<Event> qualificationEvents = this.eventRepository.query((QueryBuilder)queryBuilder);
        ArrayList<ListenableActionFuture<DeleteResponse>> deleteResponses = new ArrayList<ListenableActionFuture<DeleteResponse>>();
        for (Event event : qualificationEvents) {
            QualificationResult qualificationResult = this.transform(event);
            String testSpecName = event.getTestSpecificationName();
            BaseTestSpecification testSpecification = this.testSpecificationRepository.getById(testSpecName);
            if (testSpecification == null) {
                LOG.warn("QualificationEvent {} refers to test specification with id {}. This specification is not know in the JCR. Not importing", (Object)event, (Object)testSpecName);
                continue;
            }
            String testSpecId = testSpecification.getId();
            qualificationResult.setId(testSpecId + "/" + event.getTestRunId());
            this.testSpecificationRepository.addQualificationResult(qualificationResult);
            ListenableActionFuture<DeleteResponse> delete = this.eventRepository.delete(QUALIFICATION_COMPUTED, event.getId());
            deleteResponses.add(delete);
        }
        for (ListenableActionFuture listenableActionFuture : deleteResponses) {
            listenableActionFuture.actionGet();
        }
        return true;
    }

    private QualificationResult transform(Event event) {
        QualificationResult qualificationResult = new QualificationResult();
        qualificationResult.setTime(event.getTimestampAsDate());
        if (((Boolean)event.get(QUALIFICATION)).booleanValue()) {
            qualificationResult.setResult(QualificationResult.Result.PASSED);
        } else {
            qualificationResult.setResult(QualificationResult.Result.FAILED);
        }
        String failureReason = (String)event.get(QUALIFICATION_FAILURE_REASON);
        if (failureReason != null) {
            qualificationResult.addFailureReason(failureReason);
        }
        return qualificationResult;
    }
}

