/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.XltDuplicateException;
import com.xebialabs.xltest.repository.XltProjectNotFoundException;
import com.xebialabs.xltest.utils.JcrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectRepository {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProjectRepository.class.getName());
    private final RepositoryService repository;
    private final TestSpecificationRepository testSpecificationRepository;

    @Autowired
    public ProjectRepository(RepositoryService repository, TestSpecificationRepository testSpecificationRepository) {
        this.repository = repository;
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public List<Project> getProjects() {
        return this.getProjects(new HashMap<String, String>());
    }

    public List<Project> getProjects(Map<String, String> params) {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf((String)Synthetic.PROJECT.name));
        params.forEach((k, v) -> query.addProperty(k, v));
        return this.repository.listEntities(query);
    }

    public Project getProject(String projectId) {
        return (Project)this.repository.read(Synthetic.createProjectId(projectId));
    }

    public Project createProject(Project project) {
        try {
            if (Strings.isNullOrEmpty((String)project.getId())) {
                project.setId(Synthetic.createNewProjectId());
            }
            this.checkTitleUnique(project);
            this.repository.create((ConfigurationItem[])new Project[]{project});
            Project project2 = project;
            return project2;
        }
        catch (ItemAlreadyExistsException ex) {
            throw new XltDuplicateException("The project ID: '%s' already exists.", project.getName());
        }
        catch (Exception e) {
            LOG.error("Error creating project {}. Exception: {}", (Object)project, (Object)e);
            throw e;
        }
        finally {
            LOG.info("Finished creating project {}", (Object)project);
        }
    }

    public void delete(Project project) {
        this.delete(project.getName());
    }

    public void delete(String projectId) {
        this.delete(projectId, true);
    }

    public void delete(String projectId, boolean force) {
        if (force) {
            for (BaseTestSpecification testSpecification : this.getTestSpecifications(projectId)) {
                this.testSpecificationRepository.deleteTestSpecification(projectId, testSpecification.getName());
            }
        }
        this.repository.delete(new String[]{Synthetic.createProjectId(projectId)});
    }

    public List<BaseTestSpecification> getTestSpecifications(String projectId) {
        return this.getTestSpecifications(projectId, BaseTestSpecification.class, new HashMap<String, String>());
    }

    public List<BaseTestSpecification> getTestSpecifications(String projectId, Class<?> testSpecClass, Map<String, String> queryParams) {
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf(testSpecClass));
        query.setParent(Synthetic.createProjectId(projectId));
        queryParams.forEach((k, v) -> query.addProperty(k, v));
        return this.repository.listEntities(query);
    }

    public BaseTestSpecification createSpecificationForProject(Project project, BaseTestSpecification item) {
        return this.createSpecificationForProject(project.getName(), item);
    }

    public BaseTestSpecification createSpecificationForProject(String projectId, BaseTestSpecification item) {
        ConfigurationItem[] entities;
        LOG.info("createSpecificationForProject project={} item={}", (Object)projectId, (Object)item);
        this.testSpecificationRepository.validate(item);
        if (Strings.emptyToNull((String)item.getId()) == null) {
            item.setId(Synthetic.createNewSpecificationForProjectId(projectId));
        }
        this.setOsIfLocalhost(item);
        ArrayList<ConfigurationItem> toBeCreatedItems = new ArrayList<ConfigurationItem>();
        toBeCreatedItems.add((ConfigurationItem)item);
        this.searchForNestedToBeCreatedCis((ConfigurationItem)item, toBeCreatedItems);
        for (ConfigurationItem entity : entities = toBeCreatedItems.toArray(new ConfigurationItem[toBeCreatedItems.size()])) {
            JcrUtils.validateTestSpecificationTitle(entity);
            JcrUtils.validateJcrId(entity);
            this.repository.create(new ConfigurationItem[]{entity});
        }
        return item;
    }

    public void validateProjectExists(BaseTestSpecification baseTestSpecification) {
        String projectId = baseTestSpecification.getProjectId();
        if (!this.repository.exists(projectId)) {
            throw new XltProjectNotFoundException(projectId);
        }
    }

    public void validateProjectExists(String projectId) {
        if (!this.repository.exists(Synthetic.createProjectId(projectId))) {
            throw new XltProjectNotFoundException(projectId);
        }
    }

    private void setOsIfLocalhost(BaseTestSpecification item) {
        ActiveTestSpecification testSpecification;
        Host host;
        if (item instanceof ActiveTestSpecification && (host = (testSpecification = (ActiveTestSpecification)item).getHost()).getType().instanceOf(Type.valueOf((String)"overthere.LocalHost"))) {
            host.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        }
    }

    public void update(Project project) {
        this.checkTitleUnique(project);
        this.repository.update((ConfigurationItem[])new Project[]{project});
    }

    public Result updateSpecification(String currentProjectId, String currentSpecificationName, BaseTestSpecification testSpecification) {
        this.testSpecificationRepository.validate(testSpecification);
        String originalId = Synthetic.createSpecificationForProjectId(currentProjectId, currentSpecificationName);
        if (!originalId.equals(testSpecification.getId())) {
            this.validateProjectExists(testSpecification);
            this.repository.move(originalId, testSpecification.getId());
            return Result.MOVED;
        }
        this.repository.createOrUpdate((ConfigurationItem[])new BaseTestSpecification[]{testSpecification});
        return Result.UPDATED;
    }

    public BaseTestSpecification updateSpecificationOnly(BaseTestSpecification testSpecification) {
        this.validateProjectExists(testSpecification);
        this.testSpecificationRepository.validate(testSpecification);
        this.repository.createOrUpdate((ConfigurationItem[])new BaseTestSpecification[]{testSpecification});
        return this.testSpecificationRepository.getById(testSpecification.getName());
    }

    private void searchForNestedToBeCreatedCis(ConfigurationItem item, List<ConfigurationItem> toBeCreatedCis) {
        for (PropertyDescriptor property : item.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            if (property.getKind() != PropertyKind.CI || (child = (ConfigurationItem)item.getProperty(property.getName())) == null || this.repository.exists(child.getId())) continue;
            toBeCreatedCis.add(0, child);
            this.searchForNestedToBeCreatedCis(child, toBeCreatedCis);
        }
    }

    private void checkTitleUnique(final Project project) {
        String title = project.getTitle();
        if (Strings.isNullOrEmpty((String)title)) {
            throw new IllegalArgumentException("Project.title should be set");
        }
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf((String)Synthetic.PROJECT.name));
        query.addProperty("title", title);
        List configurationItems = this.repository.listEntities(query);
        Collection filtered = Collections2.filter((Collection)configurationItems, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem item) {
                return !item.getId().equals(project.getId());
            }
        });
        if (!filtered.isEmpty()) {
            throw new XltDuplicateException("The title: '%s' already exists", title);
        }
    }

    public void moveAllTestSpecifications(String projectId, String moveToProject) {
        List<BaseTestSpecification> testSpecifications = this.getTestSpecifications(projectId);
        for (BaseTestSpecification testSpecification : testSpecifications) {
            String newId = Synthetic.createSpecificationForProjectId(moveToProject, testSpecification.getName());
            this.repository.move(testSpecification.getId(), newId);
        }
    }

    public static enum Result {
        MOVED,
        UPDATED;

    }
}

