/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(description="A qualification result", root=Metadata.ConfigurationItemRoot.NESTED, versioned=false)
public class QualificationResult
extends BaseConfigurationItem {
    @Property(asContainment=true)
    private BaseTestSpecification testSpecification;
    @Property(required=true, description="The result of this qualification")
    private Result result = Result.FAILED;
    @Property(required=true, description="The timestamp of this qualification")
    private Date time = new Date();
    @Property(required=false, description="The failure reason for this qualification")
    private List<String> failureReason = new ArrayList<String>();
    @Property(required=false, description="Optional properties for this qualification")
    private Map<String, String> otherProperties;

    public static QualificationResult merge(QualificationResult a, QualificationResult b) {
        Result tmpResult = QualificationResult.resolve(a.getResult(), b.getResult());
        ArrayList failureReasons = Lists.newArrayList(a.failureReason);
        failureReasons.addAll(b.failureReason);
        DateTime tmpTime = a.getTime().isAfter((ReadableInstant)b.getTime()) ? a.getTime() : b.getTime();
        QualificationResult qr = QualificationResult.newInstance(a.testSpecification, UUID.randomUUID().toString());
        qr.setResult(tmpResult);
        qr.setTime(tmpTime);
        qr.setFailureReason(failureReasons);
        return qr;
    }

    public QualificationResult add(QualificationResult other) {
        if (this.result == Result.FAILED && other.result != Result.FAILED) {
            return this;
        }
        if (this.result != Result.FAILED && other.result == Result.FAILED) {
            return other;
        }
        return this;
    }

    public DateTime getTime() {
        return new DateTime((Object)this.time);
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setTime(DateTime dateTime) {
        this.time = dateTime.toDate();
    }

    public void setOtherProperties(Map<String, String> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public String getLastFailureReason() {
        return this.failureReason.isEmpty() ? "" : this.failureReason.get(this.failureReason.size() - 1);
    }

    public void setFailureReason(List<String> failureReason) {
        this.failureReason = failureReason;
    }

    public void addFailureReason(String s) {
        Preconditions.checkArgument((boolean)Strings.isNotEmpty((String)s), (Object)"argument must have string with content");
        if (this.failureReason == null) {
            this.failureReason = new ArrayList<String>();
        }
        this.failureReason.add(s);
    }

    public boolean getQualification() {
        return this.result == Result.PASSED;
    }

    public Result getResult() {
        return this.result;
    }

    public Map<String, String> getOtherProperties() {
        return this.otherProperties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("result", (Object)this.result).add("failureReason", this.failureReason).add("time", (Object)this.getTime()).add("otherProperties", this.otherProperties).toString();
    }

    public int compareTo(BaseConfigurationItem o) {
        if (!(o instanceof QualificationResult)) {
            return super.compareTo(o);
        }
        QualificationResult that = (QualificationResult)o;
        return ComparisonChain.start().compare((Comparable)this.time, (Comparable)that.time).compare((Comparable)((Object)this.id), (Comparable)((Object)that.id)).result();
    }

    public static QualificationResult newInstance(BaseTestSpecification testSpecification, String testRunId) {
        String id = testSpecification.getId() + "/" + testRunId;
        QualificationResult qr = (QualificationResult)Type.valueOf(QualificationResult.class).getDescriptor().newInstance(id);
        qr.testSpecification = testSpecification;
        return qr;
    }

    public static Result resolve(Result a, Result b) {
        if (a == Result.FAILED || b == Result.FAILED) {
            return Result.FAILED;
        }
        return Result.PASSED;
    }

    public static enum Result {
        PASSED,
        FAILED;

    }
}

