/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.configuration;

import com.google.common.base.Supplier;
import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xltest.ServerInfoProvider;
import com.xebialabs.xltest.SystemProperties;
import com.xebialabs.xltest.XltRepositoryConfig;
import com.xebialabs.xltest.elasticsearch.ElasticSearchClientFactoryBean;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.EventRepositoryImpl;
import org.elasticsearch.client.Client;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"production"})
public class ContextConfig {
    @Bean(name={"xlt.load-demo-data"})
    public boolean loadDemoData() {
        return SystemProperties.getConfig().getBoolean("xlt.load-demo-data");
    }

    @Bean
    public ServerInfo serverInfo() {
        return ServerInfoProvider.provide();
    }

    @Bean
    @Autowired
    public XlRepositoryConfig repositoryConfig(ServerConfiguration serverConfiguration) {
        RepositoryConfigurationSource repoConfigSource = new RepositoryConfigurationSource("repository.json");
        XltRepositoryConfig cfg = new XltRepositoryConfig("xlt", (Supplier<char[]>)serverConfiguration.getAdminPasswordSupplier(), repoConfigSource);
        return cfg;
    }

    @Bean
    @Autowired
    public ElasticSearchClientFactoryBean getElasticSearchFactory(@Qualifier(value="xlt.data") String elasticSearchBaseDir, @Qualifier(value="xlt.elasticsearch.http") boolean elasticSearchHttpServer, @Qualifier(value="xlt.elasticsearch.port-range") String elasticSearchPort) throws Exception {
        ElasticSearchClientFactoryBean elasticSearchFactory = new ElasticSearchClientFactoryBean();
        elasticSearchFactory.setPathData(elasticSearchBaseDir);
        elasticSearchFactory.setHttpEnabled(elasticSearchHttpServer);
        elasticSearchFactory.setPortRange(elasticSearchPort);
        return elasticSearchFactory;
    }

    @Bean
    public Config config() {
        Config config = SystemProperties.getConfig();
        return config;
    }

    @Bean
    @Autowired
    TransactionManagerLookup transactionManagerLookup() {
        return new DummyTransactionManagerLookup();
    }

    @Bean
    public EventRepository eventRepository(Client client) throws NoSuchMethodException {
        return new EventRepositoryImpl(client, false);
    }
}

