/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xltest.api.v1.dto.TestToolResponse;
import com.xebialabs.xltest.repository.TestToolRepository;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/testtools")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestToolsController {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolsController.class);
    private final TestToolRepository testToolRepository;

    @Autowired
    public TestToolsController(TestToolRepository testToolRepository) {
        this.testToolRepository = testToolRepository;
    }

    @GET
    @Path(value="/")
    public Response getTestToolRepository() {
        List<Descriptor> scriptedTestTools = this.testToolRepository.getTestToolConfigurations();
        ArrayList<TestToolResponse> toolList = new ArrayList<TestToolResponse>();
        for (Descriptor testTool : scriptedTestTools) {
            String pattern = testTool.getPropertyDescriptor("defaultSearchPattern").getDefaultValue().toString();
            String category = testTool.getPropertyDescriptor("category").getDefaultValue().toString();
            toolList.add(new TestToolResponse(testTool.getType().toString(), testTool.getLabel(), testTool.getDescription(), pattern, category));
        }
        return Response.ok(toolList).build();
    }
}

