/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Collection;
import java.util.function.Predicate;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/qualifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class QualificationControllerInternal {
    @GET
    @Path(value="/")
    public Response getAll(@QueryParam(value="category") String category) throws JSONException {
        String genericQualification = "xlt.Qualification";
        Descriptor genericQualificationDescriptor = DescriptorRegistry.getDescriptor((String)genericQualification);
        Collection subtypes = DescriptorRegistry.getSubtypes((Type)genericQualificationDescriptor.getType());
        JSONArray json = new JSONArray();
        subtypes.stream().filter(eachQualificationType -> !eachQualificationType.getDescriptor().isVirtual()).filter(this.byCategory(category)).forEach(eachQualificationType -> json.put((Object)eachQualificationType.toString()));
        return Response.ok((Object)json.toString()).build();
    }

    private Predicate<Type> byCategory(String category) {
        return eachQualificationType -> {
            if (Strings.isNullOrEmpty((String)category)) {
                return true;
            }
            PropertyDescriptor propertyDescriptor = eachQualificationType.getDescriptor().getPropertyDescriptor("applicableCategories");
            if (propertyDescriptor == null) {
                return false;
            }
            Object defaultValue = propertyDescriptor.getDefaultValue();
            return defaultValue instanceof Collection && ((Collection)defaultValue).contains(category);
        };
    }
}

