/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.Dashboard;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.repository.DashboardRepository;
import com.xebialabs.xltest.serialize.CiDepth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/dashboards")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class DashboardController {
    private static final Logger LOG = LoggerFactory.getLogger((String)DashboardController.class.getName());
    private DashboardRepository dashboardRepository;
    private RepositoryService repository;
    private Validator validator;

    @Autowired
    public DashboardController(RepositoryService repository, Validator validator, DashboardRepository dashboardRepository) {
        this.repository = repository;
        this.validator = validator;
        this.dashboardRepository = dashboardRepository;
    }

    @GET
    @Path(value="/")
    @CiDepth(value=1)
    public List<Dashboard> getDashboards() {
        List<Dashboard> dashboards = this.dashboardRepository.getAllEnhancedWithReportProperties();
        this.sortOnTitle(dashboards);
        return dashboards;
    }

    @GET
    @Path(value="/{id:.+}")
    @CiDepth(value=1)
    public Dashboard getDashboard(@PathParam(value="id") String id) {
        LOG.info("reading dashboard with id: {}", (Object)id);
        try {
            return this.dashboardRepository.getById(id);
        }
        catch (NotFoundException e) {
            LOG.error("Couldn't find dashboard {}", (Object)id);
            throw e;
        }
    }

    @PUT
    @Path(value="/{id:.+}")
    public void update(@PathParam(value="id") String id, BaseConfigurationItem item) {
        LOG.info("update dashboard id: {}", (Object)id);
        if (!id.equals(item.getId())) {
            throw new IllegalArgumentException("Passed dashboard " + item.getId() + ", but expected " + id);
        }
        this.dashboardRepository.update(id, (Dashboard)item);
    }

    @POST
    @Path(value="/duplicate/{id:.+}")
    public Response duplicate(@PathParam(value="id") String fromDashboardId, BaseConfigurationItem item) {
        LOG.info("duplicate: fromDashboardId={} item={}", (Object)fromDashboardId, (Object)item);
        Dashboard fromDashboard = (Dashboard)this.repository.read(fromDashboardId);
        Dashboard dashboard = (Dashboard)item;
        this.generateDashboardId(dashboard);
        this.repository.create((ConfigurationItem[])new Dashboard[]{dashboard});
        Dashboard createdDashboard = (Dashboard)this.repository.read(dashboard.getId());
        List<DashboardTile> copiedTiles = fromDashboard.getDashboardTiles().stream().map(eachToBeCopied -> eachToBeCopied.copyToDashboard(createdDashboard)).collect(Collectors.toList());
        createdDashboard.setDashboardTiles(copiedTiles);
        ArrayList<BaseConfigurationItem> items = new ArrayList<BaseConfigurationItem>();
        items.add(createdDashboard);
        items.addAll(this.populateIdsInTilesCreatedByFrontend(copiedTiles, dashboard));
        this.repository.createOrUpdate(items.toArray(new ConfigurationItem[items.size()]));
        Dashboard theCopy = (Dashboard)this.repository.read(dashboard.getId());
        return Response.status((int)201).entity((Object)theCopy).build();
    }

    @POST
    @Path(value="/")
    public Response create(BaseConfigurationItem item) {
        try {
            this.dashboardRepository.create(item);
            Response response = Response.status((int)201).entity((Object)item).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Error creating dashboard item={} {}", (Object)item, (Object)e);
            throw e;
        }
        finally {
            LOG.info("create dashboard done item={}", (Object)item);
        }
    }

    @DELETE
    @Path(value="/{id:.+}")
    public Response delete(@PathParam(value="id") String id) {
        LOG.info("delete dashboard: {}", (Object)id);
        this.repository.delete(new String[]{id});
        return Response.status((int)204).build();
    }

    private List<DashboardTile> populateIdsInTilesCreatedByFrontend(List<DashboardTile> tiles, Dashboard dashboard) {
        tiles.stream().filter(tile -> tile.getName().contains(tile.getTitle())).forEach(tile -> tile.setId(dashboard.getId() + "/" + UUID.randomUUID().toString()));
        return tiles;
    }

    private void generateDashboardId(Dashboard dashboard) {
        dashboard.setId(Synthetic.DASHBOARD.jcrDirectory + "/" + UUID.randomUUID().toString());
    }

    private void sortOnTitle(List<Dashboard> dashboards) {
        Collections.sort(dashboards, new Comparator<Dashboard>(){

            @Override
            public int compare(Dashboard o1, Dashboard o2) {
                return ComparisonChain.start().compare((Comparable)((Object)o1.getTitle()), (Comparable)((Object)o2.getTitle())).compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())).result();
            }
        });
    }
}

