/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.google.common.base.Throwables;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.xltest.MainOptions;
import com.xebialabs.xltest.Spinner;
import com.xebialabs.xltest.XLTest;
import com.xebialabs.xltest.configuration.BootstrapConfiguration;
import com.xebialabs.xltest.upgrade.jcr.XlTestViewUpgrader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static Collection<URL> toURL(String base, String sub) throws IOException {
        File f = new File(base, sub);
        if (f.isFile()) {
            return Arrays.asList(f.toURI().toURL());
        }
        UrlCollector collector = new UrlCollector();
        Files.walkFileTree(f.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, collector);
        return collector.getUrls();
    }

    public static void main(String[] args) throws Exception {
        Main.takeOverJavaUtilLogging();
        MainOptions cmdOptions = new MainOptions();
        CmdLineParser parser = new CmdLineParser((Object)cmdOptions);
        Main.setupPluginClasspath();
        try {
            parser.parseArgument(args);
            LOG.info("Program options {} - with arguments {}", (Object)cmdOptions, (Object)args);
            if (cmdOptions.isUpgrade()) {
                Main.upgrade();
            } else {
                Main.bootstrapXlTest(cmdOptions.isForceUpgrades());
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void takeOverJavaUtilLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getGlobal().setLevel(Level.FINEST);
    }

    private static void setupPluginClasspath() throws IOException {
        String home = System.getProperty("user.dir");
        Collection<URL> classpath = Main.toURL(home, "plugins");
        LOG.info("Plugin classpath: {}", classpath);
        URLClassLoader classLoader = new URLClassLoader(classpath.toArray(new URL[classpath.size()]));
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public static void upgrade() {
        Spinner spinner = new Spinner("Upgrading XL TestView");
        spinner.start();
        AnnotationConfigApplicationContext ctx = null;
        try {
            LocalBooter.boot();
            Security.addProvider((Provider)new BouncyCastleProvider());
            System.setProperty("spring.profiles.default", "production");
            ctx = new AnnotationConfigApplicationContext(new Class[]{BootstrapConfiguration.class});
            ctx.registerShutdownHook();
            XlTestViewUpgrader upgrader = (XlTestViewUpgrader)((Object)ctx.getBean(XlTestViewUpgrader.class));
            upgrader.autoUpgrade();
            LOG.info("XL TestView upgrade finished.");
            spinner.finish();
            Main.upgradeSuccessBanner();
            LOG.info("XL TestView shutting down.");
            ctx.close();
            LOG.info("XL TestView stopped.");
            System.exit(0);
        }
        catch (Error | Exception e) {
            if (ctx != null) {
                ctx.close();
            }
            spinner.finishQuietly();
            Main.upgradeFailBanner(Throwables.getRootCause((Throwable)e).getMessage());
            System.exit(1);
        }
    }

    public static void bootstrapXlTest(boolean forceUpgrades) {
        Spinner spinner = new Spinner("Starting XL TestView");
        spinner.start();
        try {
            LocalBooter.boot();
            XLTest xltest = new XLTest(forceUpgrades);
            xltest.startWebApp();
            spinner.finish();
            Main.successBanner(xltest);
            LOG.info("XL TestView up and running");
            xltest.join();
            System.exit(0);
        }
        catch (Error | Exception e) {
            spinner.finishQuietly();
            Main.failBanner(Throwables.getRootCause((Throwable)e).getMessage());
            LOG.error("Startup failed", e);
            System.exit(1);
        }
    }

    private static void successBanner(XLTest xltest) {
        System.out.println();
        String bindAddress = xltest.webAppBindAddress();
        System.out.println(String.format("Please open http://%s:%d with a modern browser.", bindAddress.equals("0.0.0.0") ? "localhost" : bindAddress, xltest.webAppPortNumber()));
        System.out.println();
    }

    private static void upgradeSuccessBanner() {
        System.out.println();
        System.out.println(String.format("XL TestView Upgrade succeeded", new Object[0]));
        System.out.println();
    }

    private static void failBanner(String message) {
        System.err.println();
        System.err.println(String.format("XL TestView Startup failed: %s%n%nThe server logs may contain more information.", message));
        System.err.println();
    }

    private static void upgradeFailBanner(String message) {
        System.err.println();
        System.err.println(String.format("XL TestView Upgrade failed: %s%n%nThe server logs may contain more information.", message));
        System.err.println();
    }

    private static class UrlCollector
    implements FileVisitor<Path> {
        private List<URL> urls = new ArrayList<URL>();

        private UrlCollector() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.urls.add(dir.toUri().toURL());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            LOG.debug("Scanned {} succesfully", (Object)file);
            this.urls.add(file.toUri().toURL());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            LOG.error("Error scanning " + file.toString(), (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                LOG.debug("Scanned {} successfully", (Object)dir);
            } else {
                LOG.error("Error scanning " + dir.toString(), (Throwable)exc);
            }
            return FileVisitResult.CONTINUE;
        }

        public List<URL> getUrls() {
            return this.urls;
        }
    }
}

