/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlElement;
import java.util.Stack;

public class HtmlWriter {
    private StringBuilder html = new StringBuilder();
    private int lastEndLine = -1;
    private Tags tags = new Tags();

    public void startTag(String tag) {
        this.closeCurrentTag(false);
        this.indentTag();
        this.tags.push(tag, false);
        this.writeTag(tag);
    }

    public void startTagInline(String tag) {
        this.closeCurrentTag(true);
        this.tags.push(tag, true);
        this.writeTag(tag);
    }

    public void putText(String text) {
        this.closeCurrentTag(true);
        this.html.append(text);
    }

    private void writeTag(String tag) {
        this.html.append('<');
        this.html.append(tag);
    }

    private void indentTag() {
        for (int i = 0; i < this.tags.size(); ++i) {
            this.html.append('\t');
        }
    }

    private void closeCurrentTag(boolean newTagInline) {
        if (this.tags.size() > 0) {
            if (this.tags.isOpen()) {
                this.html.append('>');
                this.tags.close();
            }
            if (!newTagInline) {
                this.writeEndLine();
            }
        }
    }

    public void endTag() {
        Tag tag = this.tags.pop();
        if (tag.open) {
            this.html.append(" />");
        } else {
            if (this.html.length() == this.lastEndLine) {
                this.indentTag();
            }
            this.html.append("</");
            this.html.append(tag.name);
            this.html.append('>');
        }
        if (!tag.inline) {
            this.writeEndLine();
        }
    }

    private void writeEndLine() {
        if (this.html.length() == this.lastEndLine) {
            return;
        }
        this.html.append(HtmlElement.endl);
        this.lastEndLine = this.html.length();
    }

    public void putTag(String tag) {
        this.startTag(tag);
        this.endTag();
    }

    public void putTagInline(String tag) {
        this.startTagInline(tag);
        this.endTag();
    }

    public void putAttribute(String name, String value) {
        this.html.append(' ');
        this.html.append(name);
        this.html.append("=\"");
        this.html.append(value);
        this.html.append('\"');
    }

    public String toHtml() {
        return this.html.toString();
    }

    private class Tag {
        public String name;
        public boolean open;
        public boolean inline;

        public Tag(String name, boolean inline) {
            this.name = name;
            this.inline = inline;
            this.open = true;
        }
    }

    private class Tags {
        private Stack<Tag> tags = new Stack();
        private Tag top = new Tag(null, false);
        private boolean isEmpty = true;

        private Tags() {
        }

        public void push(String name, boolean inline) {
            if (!this.isEmpty) {
                this.tags.push(this.top);
                this.top = new Tag(name, inline);
            } else {
                this.top.name = name;
                this.top.inline = inline;
                this.isEmpty = false;
            }
        }

        public Tag pop() {
            Tag result = this.top;
            if (this.tags.empty()) {
                this.isEmpty = true;
            } else {
                this.top = this.tags.pop();
            }
            return result;
        }

        public int size() {
            return this.tags.size() + (this.isEmpty ? 0 : 1);
        }

        public boolean isOpen() {
            return this.top.open;
        }

        public void close() {
            this.top.open = false;
        }
    }
}

