/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.refactoring.ReferenceRenamer;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiWord;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PageReferenceRenamer
extends ReferenceRenamer {
    private static final Logger LOG = Logger.getLogger(PageReferenceRenamer.class.getName());
    private WikiPage subjectPage;
    private String newName;

    public PageReferenceRenamer(WikiPage root, WikiPage subjectPage, String newName) {
        super(root);
        this.subjectPage = subjectPage;
        this.newName = newName;
    }

    @Override
    public boolean visit(Symbol node) {
        try {
            String aliasReference;
            if (node.isType(WikiWord.symbolType)) {
                new WikiWordReference(this.currentPage, node.getContent()).wikiWordRenamePageIfReferenced(node, this.subjectPage, this.newName);
            } else if (node.isType(Alias.symbolType) && PathParser.isWikiPath(aliasReference = node.childAt(1).childAt(0).getContent())) {
                new WikiWordReference(this.currentPage, aliasReference).wikiWordRenamePageIfReferenced(node.childAt(1).childAt(0), this.subjectPage, this.newName);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to rename moved page references", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return !node.isType(Alias.symbolType);
    }
}

