/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.XmlUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.XmlizePageCondition;
import fitnesse.wiki.XmlizerPageHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageXmlizer {
    private final DateFormat dateFormat = WikiPageProperty.getTimeFormat();
    private LinkedList<XmlizePageCondition> pageConditions = new LinkedList();

    public Document xmlize(WikiPage page) {
        Document document = XmlUtil.newDocument();
        Element pageElement = this.createXmlFromPage(document, page);
        document.appendChild(pageElement);
        return document;
    }

    public void deXmlize(Document doc, WikiPage context, XmlizerPageHandler handler) {
        Element pageElement = doc.getDocumentElement();
        this.addChildFromXml(pageElement, context, handler);
    }

    public void deXmlizeSkippingRootLevel(Document document, WikiPage context, XmlizerPageHandler handler) {
        Element pageElement = document.getDocumentElement();
        this.addChildrenFromXml(pageElement, context, handler);
    }

    public Document xmlize(PageData data) {
        Document document = XmlUtil.newDocument();
        Element dataElement = document.createElement("data");
        XmlUtil.addCdataNode(dataElement, "content", data.getContent());
        Element propertiesElement = data.getProperties().makeRootElement(document);
        dataElement.appendChild(propertiesElement);
        document.appendChild(dataElement);
        return document;
    }

    public PageData deXmlizeData(Document document) {
        Element dataElement = document.getDocumentElement();
        String content = XmlUtil.getLocalTextValue(dataElement, "content");
        Element propertiesElement = XmlUtil.getLocalElementByTagName(dataElement, "properties");
        WikiPageProperties properties = new WikiPageProperties(propertiesElement);
        return new PageData(content, properties);
    }

    private void addPageXmlToElement(Element context, WikiPage page) {
        if (this.pageMeetsConditions(page)) {
            context.appendChild(this.createXmlFromPage(context.getOwnerDocument(), page));
        }
    }

    private boolean pageMeetsConditions(WikiPage page) {
        for (XmlizePageCondition xmlizePageCondition : this.pageConditions) {
            if (xmlizePageCondition.canBeXmlized(page)) continue;
            return false;
        }
        return true;
    }

    private Element createXmlFromPage(Document document, WikiPage page) {
        Element pageElement = document.createElement("page");
        XmlUtil.addTextNode(pageElement, "name", page.getName());
        this.addLastModifiedTag(page, pageElement);
        this.addXmlFromChildren(page, pageElement);
        return pageElement;
    }

    private void addLastModifiedTag(WikiPage page, Element pageElement) {
        Date lastModificationTime = page.getData().getProperties().getLastModificationTime();
        String lastModifiedTimeString = this.dateFormat.format(lastModificationTime);
        XmlUtil.addTextNode(pageElement, "lastModified", lastModifiedTimeString);
    }

    private void addXmlFromChildren(WikiPage page, Element pageElement) {
        Element childrenElement = pageElement.getOwnerDocument().createElement("children");
        List<WikiPage> children = page.getChildren();
        Collections.sort(children);
        for (WikiPage child : children) {
            this.addPageXmlToElement(childrenElement, child);
        }
        pageElement.appendChild(childrenElement);
    }

    private void addChildFromXml(Element pageElement, WikiPage context, XmlizerPageHandler handler) {
        Date modifiedDate;
        String name = XmlUtil.getTextValue(pageElement, "name");
        String modifiedDateString = XmlUtil.getTextValue(pageElement, "lastModified");
        try {
            modifiedDate = modifiedDateString == null ? new Date(0L) : this.dateFormat.parse(modifiedDateString);
        }
        catch (ParseException e) {
            modifiedDate = new Date(0L);
        }
        WikiPage childPage = context.getChildPage(name);
        if (childPage == null) {
            childPage = context.addChildPage(name);
        }
        handler.enterChildPage(childPage, modifiedDate);
        this.addChildrenFromXml(pageElement, childPage, handler);
        handler.exitPage();
    }

    private void addChildrenFromXml(Element pageElement, WikiPage contextPage, XmlizerPageHandler handler) {
        Element childrenElement = XmlUtil.getLocalElementByTagName(pageElement, "children");
        NodeList childNodes = childrenElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"page".equals(node.getNodeName())) continue;
            this.addChildFromXml((Element)node, contextPage, handler);
        }
    }

    public void addPageCondition(XmlizePageCondition xmlizePageCondition) {
        this.pageConditions.add(xmlizePageCondition);
    }
}

