/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.Updater;
import fitnesse.updates.FileUpdate;
import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.FileUtil;

public class WikiContentUpdater
implements Updater {
    private static final Logger LOG = Logger.getLogger(WikiContentUpdater.class.getName());
    protected final FitNesseContext context;
    private Properties rootProperties;
    private String fitNesseVersion;

    public WikiContentUpdater(FitNesseContext context) throws IOException {
        this.context = context;
        this.rootProperties = this.loadProperties();
        this.fitNesseVersion = context.version.toString();
    }

    @Override
    public boolean update() throws IOException {
        if (this.shouldUpdate()) {
            LOG.info("Unpacking new version of FitNesse resources. Please be patient...");
            this.performAllupdates();
            this.getProperties().put("Version", this.fitNesseVersion);
            this.saveProperties();
            return true;
        }
        return false;
    }

    Properties getProperties() {
        return this.rootProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        File propFile = this.getPropertiesFile();
        if (propFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propFile);
                properties.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return properties;
    }

    private File getPropertiesFile() {
        return new File(this.context.getRootPagePath(), "properties");
    }

    void saveProperties() throws IOException {
        FileOutputStream os = null;
        File propFile = this.getPropertiesFile();
        try {
            os = new FileOutputStream(propFile);
            this.rootProperties.store(os, "#FitNesse properties");
        }
        catch (IOException e) {
            String fileName = propFile.getAbsolutePath();
            LOG.log(Level.SEVERE, "Failed to save properties file: \"" + fileName + "\". (exception: " + e + ")");
            throw e;
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    boolean performAllupdates() throws IOException {
        List<Update> updates = this.makeAllUpdates();
        for (Update update : updates) {
            if (!update.shouldBeApplied()) continue;
            this.performUpdate(update);
        }
        return true;
    }

    private void performUpdate(Update update) {
        try {
            update.doUpdate();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Update failed", e);
        }
    }

    List<Update> makeAllUpdates() throws IOException {
        ArrayList<Update> updates = new ArrayList<Update>();
        updates.addAll(this.addAllFilesToBeUpdated("updateList", new UpdateFactory(){

            @Override
            public Update create(String source, File destination) {
                return new ReplacingFileUpdate(source, destination);
            }
        }));
        updates.addAll(this.addAllFilesToBeUpdated("updateDoNotCopyOverList", new UpdateFactory(){

            @Override
            public Update create(String source, File destination) {
                return new FileUpdate(source, destination);
            }
        }));
        return updates;
    }

    private List<Update> addAllFilesToBeUpdated(String updateFile, UpdateFactory updateFactory) throws IOException {
        String updateFileResource = this.getCorrectPathFromJar(updateFile);
        String[] updateList = this.parseResource(updateFileResource);
        ArrayList<Update> updates = new ArrayList<Update>();
        for (String updateableFile : updateList) {
            File path = this.getCorrectPathForTheDestination(updateableFile);
            String source = this.getCorrectPathFromJar(updateableFile);
            updates.add(updateFactory.create(source, path));
        }
        return updates;
    }

    String getCorrectPathFromJar(String updateableFile) {
        return "Resources/" + updateableFile;
    }

    File getCorrectPathForTheDestination(String updateableFile) {
        if (updateableFile.startsWith("FitNesseRoot")) {
            updateableFile = updateableFile.replace("FitNesseRoot", this.context.getRootPagePath());
        }
        return new File(updateableFile).getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] parseResource(String resourceName) throws IOException {
        InputStream in = null;
        try {
            in = ClassLoader.getSystemResourceAsStream(resourceName);
            String content = FileUtil.toString(in);
            String[] stringArray = content.split("\n");
            return stringArray;
        }
        finally {
            FileUtil.close(in);
        }
    }

    private boolean shouldUpdate() {
        String versionProperty = this.getProperties().getProperty("Version");
        return versionProperty == null || !versionProperty.equals(this.fitNesseVersion);
    }

    public void setFitNesseVersion(String version) {
        this.fitNesseVersion = version;
    }

    static interface UpdateFactory {
        public Update create(String var1, File var2);
    }
}

