/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

public class Disgracer {
    public boolean capitalizeNextWord;
    public StringBuffer disgracedName;
    private String name;

    public Disgracer(String name) {
        this.name = name;
    }

    public static String disgraceClassName(String name) {
        return new Disgracer(name).disgraceClassNameIfNecessary();
    }

    public static String disgraceMethodName(String name) {
        return new Disgracer(name).disgraceMethodNameIfNecessary();
    }

    private String disgraceMethodNameIfNecessary() {
        if (this.isGraceful()) {
            return this.disgraceMethodName();
        }
        return this.name;
    }

    private String disgraceMethodName() {
        this.capitalizeNextWord = false;
        return this.disgraceName();
    }

    private String disgraceClassNameIfNecessary() {
        if (this.nameHasDotsBeforeEnd() || this.nameHasDollars()) {
            return this.name;
        }
        if (this.isGraceful()) {
            return this.disgraceClassName();
        }
        return this.name;
    }

    private boolean nameHasDollars() {
        return this.name.contains("$");
    }

    private String disgraceClassName() {
        this.capitalizeNextWord = true;
        return this.disgraceName();
    }

    private boolean nameHasDotsBeforeEnd() {
        int dotIndex = this.name.indexOf(".");
        return dotIndex != -1 && dotIndex != this.name.length() - 1;
    }

    private String disgraceName() {
        this.disgracedName = new StringBuffer();
        for (char c : this.name.toCharArray()) {
            this.appendCharInProperCase(c);
        }
        return this.disgracedName.toString();
    }

    private void appendCharInProperCase(char c) {
        if (this.isGraceful(c)) {
            this.capitalizeNextWord = true;
        } else {
            this.appendProperlyCapitalized(c);
        }
    }

    private void appendProperlyCapitalized(char c) {
        this.disgracedName.append(this.capitalizeNextWord ? Character.toUpperCase(c) : c);
        this.capitalizeNextWord = false;
    }

    private boolean isGraceful() {
        boolean isGraceful = false;
        for (char c : this.name.toCharArray()) {
            if (!this.isGraceful(c)) continue;
            isGraceful = true;
        }
        return isGraceful;
    }

    private boolean isGraceful(char c) {
        return !Character.isLetterOrDigit(c) && c != '_';
    }
}

