/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.NameTranslatorIdentity;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.slim.StatementExecutor;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.StatementTimeoutExecutor;

public class JavaSlimFactory
extends SlimFactory {
    private final NameTranslator identityTranslator = new NameTranslatorIdentity();
    private final Integer timeout;
    private final boolean verbose;

    private JavaSlimFactory(Integer timeout, boolean verbose) {
        this.timeout = timeout;
        this.verbose = verbose;
    }

    @Override
    public StatementExecutorInterface getStatementExecutor() {
        StatementExecutorInterface statementExecutor = new StatementExecutor();
        if (this.timeout != null) {
            statementExecutor = StatementTimeoutExecutor.decorate(statementExecutor, this.timeout);
        }
        return statementExecutor;
    }

    @Override
    public NameTranslator getMethodNameTranslator() {
        return this.getIdentityTranslator();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    private NameTranslator getIdentityTranslator() {
        return this.identityTranslator;
    }

    public static SlimFactory createJavaSlimFactory(SlimService.Options options) {
        return JavaSlimFactory.createJavaSlimFactory(options.statementTimeout, options.verbose);
    }

    public static SlimFactory createJavaSlimFactory(Integer timeout, boolean verbose) {
        return new JavaSlimFactory(timeout, verbose);
    }

    public static SlimFactory createJavaSlimFactory() {
        return new JavaSlimFactory(null, false);
    }
}

