/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.responders.ErrorResponder;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.wiki.PathParser;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.velocity.VelocityContext;
import util.FileUtil;

public class PageHistoryResponder
implements SecureResponder {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleResponse response;
    private PageHistory pageHistory;
    private HtmlPage page;
    private FitNesseContext context;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.prepareResponse(request);
        if (request.hasInput("resultDate")) {
            return this.tryToMakeTestExecutionReport(request);
        }
        if (this.formatIsXML(request)) {
            return this.makePageHistoryXmlResponse();
        }
        return this.makePageHistoryResponse(request);
    }

    private Response makePageHistoryResponse(Request request) {
        this.page.setTitle("Page History");
        this.page.put("pageHistory", this.pageHistory);
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.setMainTemplate("pageHistory");
        return this.makeResponse();
    }

    private Response makePageHistoryXmlResponse() {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("pageHistory", this.pageHistory);
        this.response.setContentType("text/xml");
        this.response.setContent(this.context.pageFactory.render(velocityContext, "pageHistoryXML.vm"));
        return this.response;
    }

    private boolean formatIsXML(Request request) {
        String format = request.getInput("format");
        return "xml".equalsIgnoreCase(format);
    }

    private Response tryToMakeTestExecutionReport(Request request) {
        Date resultDate;
        String date = request.getInput("resultDate");
        if ("latest".equals(date)) {
            resultDate = this.pageHistory.getLatestDate();
        } else {
            try {
                resultDate = this.dateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid date format provided", e);
            }
        }
        TestResultRecord testResultRecord = this.pageHistory.get(resultDate);
        try {
            return this.makeTestExecutionReportResponse(request, resultDate, testResultRecord);
        }
        catch (Exception e) {
            return this.makeCorruptFileResponse(request);
        }
    }

    private Response makeCorruptFileResponse(Request request) {
        return new ErrorResponder("Corrupt Test Result File").makeResponse(this.context, request);
    }

    private Response makeTestExecutionReportResponse(Request request, Date resultDate, TestResultRecord testResultRecord) throws Exception {
        if (this.formatIsXML(request)) {
            return this.generateXMLResponse(testResultRecord.getFile());
        }
        String content = FileUtil.getFileContent(testResultRecord.getFile());
        ExecutionReport report = ExecutionReport.makeReport(content);
        if (report instanceof TestExecutionReport) {
            report.setDate(resultDate);
            return this.generateHtmlTestExecutionResponse(request, (TestExecutionReport)report);
        }
        if (report instanceof SuiteExecutionReport) {
            return this.generateHtmlSuiteExecutionResponse(request, (SuiteExecutionReport)report);
        }
        return this.makeCorruptFileResponse(request);
    }

    private Response generateHtmlSuiteExecutionResponse(Request request, SuiteExecutionReport report) throws Exception {
        this.page.setTitle("Suite Execution Report");
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.put("suiteExecutionReport", report);
        this.page.put("resultDate", this.dateFormat.format(report.getDate()));
        this.page.put("ExecutionResult", ExecutionResult.class);
        this.page.setMainTemplate("suiteExecutionReport");
        PageTitle pageTitle = new PageTitle("Suite History", PathParser.parse(request.getResource()), "");
        this.page.setPageTitle(pageTitle);
        return this.makeResponse();
    }

    private Response generateHtmlTestExecutionResponse(Request request, TestExecutionReport report) throws Exception {
        this.page.setTitle("Test Execution Report");
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.put("testExecutionReport", report);
        if (!report.getExecutionLogs().isEmpty()) {
            this.page.put("resultDate", this.dateFormat.format(report.getDate()));
        }
        this.page.put("ExecutionResult", ExecutionResult.class);
        this.page.setMainTemplate("testExecutionReport");
        this.page.setErrorNavTemplate("errorNavigator");
        String tags = report.getResults().get(0).getTags();
        PageTitle pageTitle = new PageTitle("Test History", PathParser.parse(request.getResource()), tags);
        this.page.setPageTitle(pageTitle);
        return this.makeResponse();
    }

    private Response generateXMLResponse(File file) {
        try {
            this.response.setContent(FileUtil.getFileContent(file));
        }
        catch (IOException e) {
            this.response.setContent("Error: Unable to read file '" + file.getName() + "'\n");
        }
        this.response.setContentType(Response.Format.XML);
        return this.response;
    }

    private Response makeResponse() {
        this.response.setContent(this.page.html());
        return this.response;
    }

    private void prepareResponse(Request request) {
        this.response = new SimpleResponse();
        File resultsDirectory = this.context.getTestHistoryDirectory();
        String pageName = request.getResource();
        TestHistory history = new TestHistory(resultsDirectory, pageName);
        this.pageHistory = history.getPageHistory(pageName);
        this.page = this.context.pageFactory.newPage();
        PageTitle pageTitle = new PageTitle("Test History", PathParser.parse(request.getResource()), "");
        this.page.setPageTitle(pageTitle);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

