/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.TraversalListener;
import fitnesse.components.Traverser;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.responders.ChunkingResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.search.PageFinder;

public abstract class ResultResponder
extends ChunkingResponder
implements SecureResponder,
Traverser<WikiPage> {
    static final String[] SEARCH_ACTION_ATTRIBUTES = new String[]{"Edit", "Versions", "Properties", "Refactor", "WhereUsed"};
    static final String[] SEARCH_NAVIGATION_ATTRIBUTES = new String[]{"RecentChanges", "Files", "Search"};
    static final String SEARCH_ATTRIBUTE_SKIP = "Prune";
    static final String[] SPECIAL_ATTRIBUTES = new String[]{"SetUp", "TearDown"};

    @Override
    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    protected WikiPage getSearchScope() {
        String searchScope = this.request.getInput("searchScope");
        if (searchScope == null || searchScope.isEmpty()) {
            return this.page;
        }
        if (searchScope.equalsIgnoreCase("root")) {
            return this.root;
        }
        WikiPage scope = this.page.getPageCrawler().findAncestorWithName(searchScope);
        return scope;
    }

    @Override
    protected void doSending() {
        if (this.page == null) {
            this.page = this.root;
        }
        String queryString = this.request.getQueryString() == null ? "" : this.request.getQueryString();
        PageTitle pageTitle = new PageTitle(this.page.getPageCrawler().getFullPath());
        HtmlPage htmlPage = this.context.pageFactory.newPage();
        htmlPage.setTitle(this.getTitle());
        htmlPage.setPageTitle(pageTitle);
        htmlPage.setMainTemplate(this.getTemplate());
        htmlPage.put("queryString", queryString);
        htmlPage.put("page", this.page);
        htmlPage.put("viewLocation", this.request.getResource());
        htmlPage.setNavTemplate("viewNav");
        htmlPage.put("resultResponder", this);
        htmlPage.put("pageTypeAttributes", PageType.valuesAsString());
        htmlPage.put("actionAttributes", SEARCH_ACTION_ATTRIBUTES);
        htmlPage.put("navigationAttributes", SEARCH_NAVIGATION_ATTRIBUTES);
        htmlPage.put("securityAttributes", PageData.SECURITY_ATTRIBUTES);
        htmlPage.put("specialAttributes", SPECIAL_ATTRIBUTES);
        htmlPage.put("request", this.request);
        htmlPage.render(this.response.getWriter());
        this.response.closeAll();
    }

    @Override
    public final void traverse(TraversalListener<WikiPage> observer) {
        PageFinder pageFinder = this.getPageFinder(observer);
        if (pageFinder != null) {
            pageFinder.search(this.getSearchScope());
        }
    }

    protected abstract String getTemplate();

    protected abstract String getTitle();

    protected abstract PageFinder getPageFinder(TraversalListener<WikiPage> var1);

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

