/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.http.Request;
import fitnesse.responders.refactoring.PageMovementResponder;
import fitnesse.responders.refactoring.RefactorException;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.refactoring.PageReferenceRenamer;
import fitnesse.wiki.refactoring.ReferenceRenamer;

public class RenamePageResponder
extends PageMovementResponder {
    private String newName;

    @Override
    protected boolean getAndValidateNewParentPage(FitNesseContext context, Request request) {
        this.newParentPath = PathParser.parse(this.oldNameOfPageToBeMoved).parentPath();
        this.newParentPage = this.oldRefactoredPage.getParent();
        return this.newParentPage != null;
    }

    @Override
    protected boolean getAndValidateRefactoringParameters(Request request) {
        this.newName = request.getInput("newName");
        return this.newName != null && PathParser.isSingleWikiWord(this.newName) && !"FrontPage".equals(this.oldNameOfPageToBeMoved);
    }

    @Override
    protected ReferenceRenamer getReferenceRenamer(FitNesseContext context) {
        return new PageReferenceRenamer(context.getRootPage(), this.oldRefactoredPage, this.getNewPageName());
    }

    @Override
    protected void execute() throws RefactorException {
        WikiPage parentOfPageToRename = this.oldRefactoredPage.getParent();
        this.movePage(this.oldRefactoredPage, parentOfPageToRename, this.newName);
    }

    @Override
    protected String getNewPageName() {
        return this.newName;
    }

    @Override
    protected String getErrorMessageHeader() {
        return "Cannot rename " + this.makeLink(this.oldNameOfPageToBeMoved) + " to " + this.newName + ".";
    }
}

